const state = {
  userId: '',
  username: '',
  menuList: [],
  roleIds: [],
  permissionCodeList: []
}

const mutations = {
  SET_USER(state, userInfo) {
    state.userId = userInfo.userId
    state.username = userInfo.username
    state.menuList = userInfo.menuList
    state.roleIds = userInfo.roleIds
    state.permissionCodeList = userInfo.permissionCodeList
  },
  RESET_USER: state => {
    state.userId = ''
    state.username = ''
    state.menuList = []
    state.roleIds = []
    state.permissionCodeList = []
  }
}
const getters = {
  UserId: state => {
    return state.userId
  },
  PermissionList: state => {
    return state.permissionCodeList
  }
}
// 异步获取用户信息
const actions = {
  userMsg(context, userInfo) {
    context.commit('SET_USER', userInfo.userInfo)
  }
}

export default {
  namespaced: true,
  state,
  getters,
  mutations,
  actions
}
