import axios from 'axios'

const service = axios.create({
  baseURL: process.env.HOLMES,
  timeout: 500000
})

// request 拦截器
service.interceptors.request.use(
  config => {
    let token = window.sessionStorage.getItem('token')
    // console.log('666', token)
    if (token) {
      config.headers.token = token
    }

    return config
  },
  error => {
    console.error(error)
    Promise.reject(error)
  }
)

// response 拦截器
service.interceptors.response.use(
  response => response,
  error => {
    console.log('error' + error) // for debug
    return Promise.reject(error)
  }
)

export default service
