import holmesRequest from '@/utils/holmesRequest'
// 获取sql监控列表
export function getSqlMonitorList(queryInfo) {
  return holmesRequest({
    url: '/sql/monitor/list',
    method: 'get',
    params: queryInfo
  })
}
// 新增sql监控
export function addSqlMonitor(data) {
  return holmesRequest({
    url: '/sql/monitor/add',
    method: 'post',
    data
  })
}
// 编辑sql监控
export function editSqlMonitor(data) {
  return holmesRequest({
    url: '/sql/monitor/edit',
    method: 'post',
    data
  })
}
// 删除sql监控
export function delSqlMonitor(data) {
  return holmesRequest({
    url: '/sql/monitor/delete',
    method: 'post',
    data
  })
}
// 执行sql监控
export function executeSqlMonitor(data) {
  return holmesRequest({
    url: '/sql/monitor/execute',
    method: 'post',
    data
  })
}
// 发送sql监控
export function sendTestSqlMonitor(data) {
  return holmesRequest({
    url: '/sql/monitor/test',
    method: 'post',
    data
  })
}
// 获取数据源列表
export function getSqlMonitorData(queryInfo) {
  return holmesRequest({
    url: '/monitor/ds/list',
    method: 'get',
    params: queryInfo
  })
}
// 获取执行策略列表
export function getMonitorStrategy(queryInfo) {
  return holmesRequest({
    url: '/sql/monitor/strategy',
    method: 'get',
    params: queryInfo
  })
}
// 启用、禁用接口
export function isEnableSqlMonitor(data) {
  return holmesRequest({
    url: '/sql/monitor/enable',
    method: 'post',
    data
  })
}
// 获取sql监控详情
export function getDetailSqlMonitor(queryInfo) {
  return holmesRequest({
    url: '/sql/monitor/detail',
    method: 'get',
    params: queryInfo
  })
}
