import request from '@/utils/holmesRequest'

export function getProjectRobotList(queryInfo) {
  return request({
    url: '/jira/list/robot',
    method: 'get',
    params: queryInfo
  })
}

export function getJiraProjectList() {
  return request({
    url: '/jira/list/project',
    method: 'get'
  })
}

export function addProjectRobot(data) {
  return request({
    url: '/jira/add/robot',
    method: 'post',
    data
  })
}

export function modifyProjectRobot(data) {
  return request({
    url: '/jira/modify/robot',
    method: 'post',
    data
  })
}

export function delProjectRobot(queryInfo) {
  return request({
    url: '/jira/delete/robot',
    method: 'get',
    params: queryInfo
  })
}

export function sendScheduleReport(data) {
  return request({
    url: '/jira/send/schedule',
    method: 'post',
    data
  })
}

export function sendSmokingResult(data) {
  return request({
    url: '/jira/send/smoking',
    method: 'post',
    data
  })
}
// 获取pipeline列表接口
export function getPipelineList(queryInfo) {
  return request({
    url: '/pipeline/list',
    method: 'get',
    params: queryInfo
  })
}
// 获取所有服务列表
export function getGitProjectList(queryInfo) {
  return request({
    url: '/gitlab/projects',
    method: 'get',
    params: queryInfo
  })
}
// 获取分支列表
export function getGitBranchList(queryInfo) {
  return request({
    url: '/gitlab/branches',
    method: 'get',
    params: queryInfo
  })
}
// 添加pipeline接口
export function addPipeline(data) {
  return request({
    url: '/pipeline/add',
    method: 'post',
    data
  })
}
// 编辑pipeline接口
export function editPipeline(data) {
  return request({
    url: '/pipeline/modify',
    method: 'post',
    data
  })
}

export function getJiraIssueList(data) {
  return request({
    url: '/jira/issue/list',
    method: 'get',
    params: data
  })
}
// 删除pipeline功能
export function delPipeline(queryInfo) {
  return request({
    url: '/pipeline/delete',
    method: 'get',
    params: queryInfo
  })
}
// 改变项目状态
export function changePipelineStatus(data) {
  return request({
    url: '/pipeline/finish',
    method: 'post',
    data
  })
}
