// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import App from './App'
import '../src/assets/css/global.css'
// 引入图标库
import '../src/assets/css/iconfont.css'
import router from './router'
import echarts from 'echarts'
import 'element-ui/lib/theme-chalk/index.css'
import axios from 'axios'
import store from './store/store'
import JsonViewer from 'vue-json-viewer'
import bus from '../src/utils/bus'
import directives from '@/directives'
import * as filters from './filters' // global filters
// 新添加高亮显示关键字(2021-12-27)
import hljs from 'highlight.js'
import 'highlight.js/styles/googlecode.css'
// 引用sql编辑器(2021-12-30)
import AFTableColumn from 'af-table-column'
// sql编辑器
import { codemirror } from 'vue-codemirror'
import 'codemirror/lib/codemirror.css'

// import Sortable from 'sortablejs'
import {
  Container,
  Header,
  Aside,
  Main,
  Menu,
  Submenu,
  MenuItem,
  Card,
  Collapse,
  CollapseItem,
  Input,
  Table,
  TableColumn,
  Select,
  Option,
  Breadcrumb,
  BreadcrumbItem,
  Button,
  InputNumber,
  Tag,
  Pagination,
  Form,
  FormItem,
  Message,
  Loading,
  Dialog,
  Tabs,
  TabPane,
  Switch,
  RadioGroup,
  Radio,
  MessageBox,
  Row,
  Col,
  Tooltip,
  Dropdown,
  DropdownItem,
  DropdownMenu,
  Checkbox,
  CheckboxGroup,
  Popover,
  Alert
} from 'element-ui'

Vue.directive('highlight', function(el) {
  let blocks = el.querySelectorAll('pre code')
  // 设置定时是解决它第一次页面没有样式问题
  setTimeout(() => {
    blocks.forEach(block => {
      hljs.highlightBlock(block)
    })
  }, 200)
})
// 设置自适应宽度的比率
const fontRate = {
  CHAR_RATE: 0.4,
  NUM_RATE: 0.6,
  OTHER_RATE: 0.6
}
const fontSize = 16

Vue.config.productionTip = false

Vue.prototype.$axios = axios
Vue.prototype.$echarts = echarts

Vue.prototype.$message = Message
Vue.prototype.$loading = Loading
Vue.prototype.$messageBox = MessageBox
Vue.prototype.$confirm = MessageBox.confirm
Vue.prototype.$bus = bus
// axios.defaults.baseURL = 'https://qa-platform-pre.liangkebang.net'
// axios.defaults.baseURL = 'http://localhost:8082'

// register global utility filters.
Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
})
Vue.use(Container)
Vue.use(Header)
Vue.use(Aside)
Vue.use(Main)
Vue.use(Menu)
Vue.use(Submenu)
Vue.use(MenuItem)
Vue.use(Card)
Vue.use(Collapse)
Vue.use(CollapseItem)
Vue.use(Input)
Vue.use(Table)
Vue.use(TableColumn)
Vue.use(Select)
Vue.use(Option)
Vue.use(Breadcrumb)
Vue.use(BreadcrumbItem)
Vue.use(Button)
Vue.use(InputNumber)
Vue.use(Tag)
Vue.use(Pagination)
Vue.use(Form)
Vue.use(FormItem)
Vue.use(Dialog)
Vue.use(Tabs)
Vue.use(TabPane)
Vue.use(Switch)
Vue.use(RadioGroup)
Vue.use(Radio)
Vue.use(Row)
Vue.use(Col)
Vue.use(JsonViewer)
Vue.use(Tooltip)
Vue.use(directives)
Vue.use(Dropdown)
Vue.use(DropdownItem)
Vue.use(DropdownMenu)
Vue.use(Checkbox)
Vue.use(CheckboxGroup)
Vue.use(Popover)
Vue.use(Alert)
Vue.use(AFTableColumn, { fontRate, fontSize })
Vue.use(codemirror)
// Vue.use(Sortable)
/* eslint-disable no-new */

new Vue({
  el: '#app',
  router,
  store,
  components: { App },
  template: '<App/>'
})
