import request from '@/utils/request'
import holmesRequest from '@/utils/holmesRequest'

export function kdspDecrypt(queryInfo) {
  return request({
    url: '/kdsp/decrypt',
    method: 'get',
    params: queryInfo
  })
}

export function getBuildList(queryInfo) {
  return request({
    url: '/jenkins/buildlist',
    method: 'get',
    params: queryInfo
  })
}

export function getJobList() {
  return request({
    url: '/jenkins/joblist',
    method: 'get'
  })
}

export function addWhiteList(data) {
  return request({
    url: '/login/addWhiteList',
    method: 'post',
    data
  })
}

export function getLoginInfoList(queryInfo) {
  return request({
    url: '/login/list',
    method: 'get',
    params: queryInfo
  })
}

export function getClearCacheList(queryInfo) {
  return holmesRequest({
    url: '/effect/cacheList',
    method: 'get',
    params: queryInfo
  })
}

export function clearCache(queryInfo) {
  return holmesRequest({
    url: '/effect/clearcache',
    method: 'get',
    params: queryInfo
  })
}

export function clearData(dataInfo) {
  return request({
    url: '/cleardata',
    method: 'get',
    params: dataInfo
  })
}
// 获取数据库列表
export function getDataBaseList(dataInfo) {
  return holmesRequest({
    url: '/dbsync/dbs',
    method: 'get',
    params: dataInfo
  })
}
// 根据数据库获取表信息
export function getTableByDataBase(dataInfo) {
  return holmesRequest({
    url: '/dbsync/tables',
    method: 'get',
    params: dataInfo
  })
}
// 同步数据库
export function synDataBase(dataInfo) {
  return holmesRequest({
    url: '/dbsync/one',
    method: 'get',
    params: dataInfo
  })
}

// 新同步数据库接口
export function dbsyncNew(data) {
  return holmesRequest({
    url: '/dbsync/new',
    method: 'post',
    data
  })
}
