import holmesRequest from '@/utils/holmesRequest'
export function getTestDescriptionList(queryInfo) {
  return holmesRequest({
    url: '/quality/testInstruction/list',
    method: 'get',
    params: queryInfo
  })
}
// 新增提测文档接口
export function addTestDescription(data) {
  return holmesRequest({
    url: '/quality/testInstruction/save',
    method: 'post',
    data
  })
}
// 编辑提测文档接口
export function editTestDescription(data) {
  return holmesRequest({
    url: '/quality/testInstruction/update',
    method: 'post',
    data
  })
}
// 删除提测文档接口
export function delTestDescription(data) {
  return holmesRequest({
    url: '/quality/testInstruction/delete',
    method: 'post',
    data
  })
}
// 提测文档详情接口
export function detailTestDescription(queryInfo) {
  return holmesRequest({
    url: '/quality/testInstruction/detail',
    method: 'get',
    params: queryInfo
  })
}
// 根据jira项目关键字获取项目列表接口
export function getTestProjectNameList(queryInfo) {
  return holmesRequest({
    url: '/quality/testInstruction/getProjectNameList',
    method: 'get',
    params: queryInfo
  })
}
