var express = require('express');
var bodyParser = require('body-parser');
var ldap = require("ldapjs");
var log4js = require('log4js');
var md5 = require('md5');
var ldap_host = "ldap://ldap.quantgroups.com:389";
// var ldap_host = "ldap://172.30.3.46:389";
let CustomConfig = require("../config/config");

log4js.configure({
	appenders: { cheese: { type: 'file', filename: 'logs/access.log' } },
	categories: { default: { appenders: ['cheese'], level: 'info' } }
});

const logger = log4js.getLogger('cheese');
const config = CustomConfig["prod"];

// 同步进行接口转发
function requestPromise(option) {
	return new Promise(function (resolve, reject) {
		request(option, function (err, res, body) {
			if (err) {
				reject(err)
			} else {
				resolve(body)
			}
		})
	})
}

function searchUser(username) {
	return new Promise(function (resolve, reject) {
		// client.unbind();
		var client = ldap.createClient({ url: ldap_host });
		client.bind('cn=common_auth_query,cn=users,DC=quantgroup,DC=cn', 'Quantgroup.com@2o17', function (err, res1) {
			var opts = {
				filter: `(SAMACCOUNTNAME=${username})`, //查询条件过滤器
				scope: 'sub',     //查询范围
				timeLimit: 500    //查询超时
			}
			try {
				client.search('DC=quantgroup,DC=cn', opts, function (err, res2) {
					var SearchSuccess = false;
					res2.on('searchEntry', function (entry) {
						SearchSuccess = true;
						resolve(entry.object);
					});
					res2.on('searchReference', function (referral) {
						client.unbind();
						resolve(false);
					});
					res2.on('error', function (err) {
						SearchSuccess = false;
						client.unbind();
						resolve(false);
					});
					res2.on('end', function (result) {
						client.unbind();
						if (false == SearchSuccess) {
							// 返回查询失败的通知
							resolve(false);
						}
					});
				});
			} catch (error) {
				logger.warn(error.toString());
				resolve(false);
			}

		}
		);
	})
}

function checkAuth(dn, pwd) {
	return new Promise(function (resolve, reject) {
		var client = ldap.createClient({ url: ldap_host });
		client.bind(dn, pwd, function (err, res1) {
			client.unbind();
			if (!err) {
				resolve(true);
			} else {
				resolve(false);
			}
		});
	})
}

let USER_SESSION = {};
let USER_SESSION_MAP = {};

function createSession(userinfo, str) {
	if (USER_SESSION_MAP[userinfo.SAMACCOUNTNAME] != undefined) {
		return USER_SESSION_MAP[userinfo.SAMACCOUNTNAME]
	}
	let token = md5(str);
	let info = {
		name: userinfo.name,
		title: userinfo.title,
		user: userinfo.SAMACCOUNTNAME,
		mail: userinfo.mail,
		create_at: new Date()
	}
	USER_SESSION[token] = info;
	logger.info(`USER_SESSION 加入 ${userinfo.name}`)
	logger.info(`USER_SESSION: ` + JSON.stringify(USER_SESSION))
	USER_SESSION_MAP[userinfo.SAMACCOUNTNAME] = token;
	return token
}

var app = express();
var admin = express(); // the sub app
app.use(bodyParser.urlencoded({ extended: false }))
app.use(bodyParser.json())
app.all('*', function (req, res, next) {
	res.header('Access-Control-Allow-Origin', '*');
	res.header('Access-Control-Allow-Headers', 'Content-Type, Content-Length, Authorization, Accept, X-Requested-With , yourHeaderFeild');
	res.header('Access-Control-Allow-Methods', 'PUT, POST, GET, DELETE, OPTIONS');
	res.header("Access-Control-Allow-Credentials", true);
	if (req.method == 'OPTIONS') {
		res.sendStatus(200); /让options请求快速返回/
	}
	else {
		next();
	}
});

// 获取现有映射关系
admin.post('/login', async function (req, res) {
	res.setHeader("Content-Type", "application/json");
	let request = req.body;
	let obj = await searchUser(request['user']);
	let re = { code: "0001", msg: "登录失败" };
	if (obj.dn) {
		let l = await checkAuth(obj.dn, request['pwd']);
		if (l) {
			let token = createSession(obj, request['user'] + request['pwd']);
			re = { code: "0000", msg: "登录成功", token: token }
			logger.info(request['user'] + JSON.stringify(re));
		}
	}
	res.send(re);
});

admin.get('/check_token', async function (req, res) {
	res.setHeader("Content-Type", "application/json");
	let re
	if (USER_SESSION[req.query.token] === undefined) {
		re = { code: "0001" }
		logger.info(`check_token失败：${req.query.token}`)
		logger.info(`USER_SESSION: ` + JSON.stringify(USER_SESSION))
	} else {
		re = USER_SESSION[req.query.token];
		re.code = "0000";
	}
	res.send(re);
});

admin.get('/get_station', async function (req, res) {
	res.setHeader("Content-Type", "application/json");
	let request = req.body;
	let re = [{
		label: "qahome",
		url: config.QaHome
	}, {
		label: "blackpreal",
		url: config.BlackPreal
	}, {
		label: "cicd",
		url: config.CiCD
	}];
	res.send(re);
});

app.use('/user', admin)

app.listen(10079, function () {
	console.log('server run on port 10079')
})
