#!/bin/bash
project_type=$1
is_public_ip=$2
ip=$3
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

trap "exec 1000>&-;exec 1000<&-;exit 0" 2
tempfifo=$$.fifo
echo "mkfifo /tmp/$tempfifo"
mkfifo /tmp/$tempfifo
exec 1000<>/tmp/$tempfifo
rm -rf /tmp/$tempfifo

function restartJavaProject()
{
        for ((i=1; i<=6; i++))
        do
                echo >&1000
        done
	projects=(`node $config_server/get_project_config.js  -type java -attr name`)
	for project_name in ${projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/restartJava.sh $project_name $config_server $project_path 1
			echo >&1000
		}&
	done
	wait
}

function restartNodeProject()
{
        for ((i=1; i<=6; i++))
        do
                echo >&1000
        done
	projects=(`node $config_server/get_project_config.js  -type node -attr name`)
	for project_name in ${projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/restartNode.sh $project_name $config_server $project_path
			echo >&1000
		}&
	done
	wait
}

function restartPythonProject()
{
	projects=(`node $config_server/get_project_config.js  -type python -attr name`)
	for project_name in ${projects[@]}
	do
		sh $pwd_path/base_script/restartPython.sh $project_name $config_server $project_path
	done
}

function restartUiProject()
{
	nginx -t;  nginx -s reload
}

if [ "$project_type" = "java" ]; then
	restartJavaProject pwd_path
elif [ "$project_type" = "node" ]; then
	restartNodeProject pwd_path
elif [ "$project_type" = "python" ]; then
	restartPythonProject pwd_path
elif [ "$project_type" = "ui" ]; then
	restartUiProject pwd_path
else
	echo "***restart java***"
	restartJavaProject pwd_path
	echo "***restart python***"
	restartPythonProject pwd_path
	echo "***restart node***"
	restartNodeProject pwd_path
	echo "***restart ui***"
	restartUiProject pwd_path
fi
