# -------------------------------------------------------------------------------
# Filename:    database_replace_ip.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: sync数据库。
# Usage：used by ../deploy/database_sync.sh
# -------------------------------------------------------------------------------

database_name=$1
mysql_host=$2
db_backup=$3

if [ ! -f ${db_backup}/${database_name}_${mysql_host}.sql ]; then
    echo "ERROR: skip import DB, because ${database_name}_${mysql_host}.sql does not exit!"
    exit -1
else
    cd $db_backup
    if [[ "${database_name}" = "sms-center" ]]
	then
		echo "DROP DATABASE \`sms-center\` " > ${database_name}_drop.sql
		echo "CREATE DATABASE IF NOT EXISTS \`sms-center\` DEFAULT CHARSET utf8 COLLATE utf8_general_ci;" > ${database_name}_create.sql
	else
		echo "DROP DATABASE ${database_name}" > ${database_name}_drop.sql
		echo "CREATE DATABASE IF NOT EXISTS ${database_name} DEFAULT CHARSET utf8 COLLATE utf8_general_ci;" > ${database_name}_create.sql
	fi

	echo "mysql -h $mysql_host -u qa -pqatest $database_name < ${database_name}_drop.sql"
	mysql -h $mysql_host -u qa -pqatest $database_name < ${database_name}_drop.sql

	echo "mysql -h $mysql_host -u qa -pqatest < ${database_name}_create.sql"
	mysql -h $mysql_host -u qa -pqatest < ${database_name}_create.sql

	echo "mysql -h $mysql_host -u qa -pqatest $database_name < ${database_name}_${mysql_host}.sql"
	mysql -h $mysql_host -u qa -pqatest $database_name < ${database_name}_${mysql_host}.sql
fi

