#!/bin/bash
project_name=$1
is_public_ip=$2
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
project_type=`node $config_server/get_project_config.js  -name $project_name -attr type`
config_path=`cat $config_server/config_path.sh`

profile=test

host=`/sbin/ifconfig -a|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d "addr:"`
echo "host=$host"
hosts=(${host//\./ })
suffix=${hosts[3]}


if [ "$project_type" = "java" ]; then
	sh $pwd_path/base_script/buildJava.sh $project_name $config_server $project_path
	# buildJavaProject $project_name $3
elif [ "$project_type" = "ui" ]; then
	sh $pwd_path/base_script/buildUi.sh $project_name $config_server $project_path
	# buildUiProject $project_name $3
elif [ "$project_type" = "node" ]; then
	sh $pwd_path/base_script/buildNode.sh $project_name $config_server $project_path
	# buildNodeProject $project_name $3
elif [ "$project_type" = "python" ]; then
	sh $pwd_path/base_script/buildPython.sh $project_name $config_server $project_path
	# buildPythonProject $project_name  $3
fi



# if [[ "$project" = "xyqb" || "$project" = "han-gu-guan" || "$project" = "di-ting" || "$project" = "xyqb-offline" || "$project" = "xyqb-user2" ]]; then
# 	echo "module is $project, need replace sms jar version from 1.0.x to 1.0.2"
# 	num=`grep -n  -A12 "<id>test</id>"  $project_path/$project/pom.xml| grep "<version>" | awk -F- '{print $1}'`
# 	echo "----$project-----pom.xml file line: $num------------"
# 	sed -i  "${num}s/1.0.[0-9]-SNAPSHOT/1.0.6.3-SNAPSHOT/"  $project_path/$project/pom.xml
# fi
#
# if [[ "$project" = "du-jiang-yan" ]]; then
# 	num=`grep -n  -A3 "<artifactId>fund-manage-sdk</artifactId>"  $project_path/$project/pom.xml| grep "<version>" | awk -F- '{print $1}'`
# 	echo "----$project-----pom.xml file line: $num------------"
# 	sed -i  "${num}s/1.0.[0-9]-SNAPSHOT/1.0.0.${suffix}-SNAPSHOT/"  $project_path/$project/pom.xml
# 	sed -i  "${num}s/1.0.[0-9].[0-9]/1.0.0.${suffix}-SNAPSHOT/"  $project_path/$project/pom.xml
# fi
#
# if [[ "$project" = "finance-api" || "$project" = "financial-system" ]]; then
#         num=`grep -n  -A1 "<artifactId>quantgroup-sms-sdk</artifactId>"  $project_path/$project/pom.xml| grep "<version>" | awk -F- '{print $1}'`
#         echo "----$project-----pom.xml file line: $num------------"
#         sed -i  "${num}s/1.0.6.3/1.0.6.3-SNAPSHOT/"  $project_path/$project/pom.xml
# fi

# function buildJavaProject()
# {
# 	project=$1
# 	config_server=$2
# 	project_path=$3
#
# 	params=`node $config_server/get_project_config.js  -name $project -attr desc/target_path/command2`
# 	params_arry=(${params//|/ })
# 	desc=${params_arry[0]}
# 	target_path=${params_arry[1]}
# 	build_command=${params_arry[2]//\^/ }
# 	sh $config_server/show_info.sh $project BUILD $desc $2
# 	cd $project_path/$project
#
# 	rm -rf $target_path
# 	rm -rf $project.jar
#
# 	nums=(`awk '/quantgroup-sms-sdk/ {print NR}' $project_path/$project/pom.xml`)
# 	for num in ${nums[@]}
# 	do
# 		lin=$[ $num+1 ]
# 		echo "$lin"
# 		sed -i "${lin}s/^.*$/\<version\>2.0.0.3-SNAPSHOT\<\/version\>/"  $project_path/$project/pom.xml
# 	done
#
# 	echo "$build_command"
# 	$build_command
# 	if [ $? = 0 ]; then
# 		echo "${project} build ok"
# 	else
# 		echo "${project} build fail"
# 		exit -1
# 	fi
# 	echo "$target_path"
# 	mv $project_path/$project/$target_path/*.jar $project_path/$project/$project.jar
# }



# function buildNodeProject()
# {
# 	project=$1
# 	params=`node $config_server/get_project_config.js  -name $project -attr desc/config_file/command/node_version`
# 	params_arry=(${params//|/ })
#
# 	desc=${params_arry[0]}
# 	config_file=${params_arry[1]}
# 	command=${params_arry[2]//\^/ }
# 	node_version=${params_arry[3]}
#
# 	sh $config_server/show_info.sh $project BUILD $desc $2
# 	# 第一步  将nginx项目的所有文件进行打包
# 	cd $project_path/$project
# 	#第二步  关联配置文件
# 	rm -rf ./$config_file
# 	echo "------ln -s $config_path/node/$project.*  ./$config_file"
# 	ln -s $config_path/node/$project.*  ./$config_file
# 	npm config set "@types:registry" http://registry.npmjs.org/
# 	npm --registry http://172.16.3.15:4873 install
#
# }



# function buildUiProject()
# {
# 	project=$1
# 	params=`node $config_server/get_project_config.js  -name $project -attr desc/config_file/command/node_version`
# 	params_arry=(${params//|/ })
#
# 	desc=${params_arry[0]}
# 	config_file=${params_arry[1]}
# 	command=${params_arry[2]//\^/ }
# 	node_version=${params_arry[3]}
#
#
# 	sh $config_server/show_info.sh $project BUILD $desc $2
# 	# 第一步  将nginx项目的所有文件进行打包
# 	cd $project_path/$project
#
# 	if [ "$node_version" = "node4" ] ;then
# 		echo "----node-V4---${node4_path}/npm install"
# 		${node4_path}/npm  install
# 	else
# 		npm --registry http://172.16.3.15:4873 install
# 	fi
# 	bower_json=`find ./ -maxdepth 1 -name "bower.json"`
#
# 	if [ -n "$bower_json" ];then
# 		echo "bower install --allow-root"
# 		bower install --allow-root
# 	else
# 		echo "don't have bower.json"
# 	fi
#
# 	$command
# 	# 第二步   不关机使得nginx生效
# 	nginx -t;  nginx -s reload
# }




# function buildPythonProject()
# {
# 	project=$1
# 	params=`node $config_server/get_project_config.js  -name $project -attr desc/config_file`
# 	params_arry=(${params//|/ })
# 	desc=${params_arry[0]}
# 	config_file=${params_arry[1]}
#
# 	sh $config_server/show_info.sh $project BUILD $desc $2
#
# 	cd $project_path/$project
# 	setup_path_temp=`find ./ -name "setup.py"`
# 	python ${setup_path_temp} install
# 	#第四步  关联配置文件
# 	rm -rf $config_file
# 	ln -s $config_path/python/$project.*  $config_file
# }
