#!/bin/bash
pwd_path_0="/home/qa-deploy-utils"
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
env_ip=`cat $config_server/get_env_ip.sh`
env_ip='12 13 14 15 16 17 22 23 24 25 26 28'

scriptname=$(basename $0)
echo -e "\033[32m使用方法：sh $scriptname 14 （同步192.168.4.14环境的MQ）\033[0m"
echo -e "\033[32m使用方法：sh $scriptname 192.168.4.14 （同步192.168.4.14环境的MQ）\033[0m"
echo -e "\033[32m使用方法：sh $scriptname （同步ip小于40环境的MQ）\033[0m"

if [ -n "$1" ];then
	env_ip=$1
fi

response=$(curl -s -X GET -H "Authorization: Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=" "http://172.16.1.231:15672/api/definitions")
if [ $? != 0 ];then
	echo curl -X GET -H "Authorization: Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=" "http://172.16.1.231:15672/api/definitions" failed !!!
	exit -1
fi

for ip_last_num in $env_ip
do
	IP_host=`sh $pwd_path_0/get-ip.sh $ip_last_num`
	#echo curl -X POST -H "Content-Type: application/json" -H "Authorization: Basic cWE6cWF0ZXN0" -d $response "http://$IP_host:15672/api/definitions"
	echo curl $IP_host ...
	curl -s -X POST -H "Content-Type: application/json" -H "Authorization: Basic cWE6cWF0ZXN0" -d $response "http://$IP_host:15672/api/definitions"
	if [ $? != 0 ];then
		echo "curl $IP_host failed"
	fi
done
