project_name=$1
target_dir="/home/quant_group/${project_name}"
qaapi='http://172.30.220.22:3003'
git_path=`curl -s "${qaapi}/proconfig/get_info?system_name=${project_name}&key=git_path"`


cd ${target_dir}
echo "目录切换到 ${target_dir}"

if [ ! -d "$project_name" ];then
	echo "项目不存在"
	git clone ${git_path}
	cd ./${project_name}
else
	echo "项目已存在"
	cd ./${project_name}
	git pull
fi

echo "开始部署项目"

if [ "$project_name" = "qa-platform-ui" ];then
	echo "这是一个UI项目"
	cd ${target_dir}
	npm install
	npm run build
	echo "重启下nginx"
	/usr/local/openresty/nginx/sbin/nginx -s reload
	echo "done"
else
	echo "这是JAVA项目"
	cd ${target_dir}
	git pull
	mvn clean package -Ptest -Dmaven.test.skip=true
	supervisorctl restart $project_name
	echo "done"
fi


