#!/bin/bash

function add_vhost()
{       
        /usr/lib/rabbitmq/bin/rabbitmqctl delete_vhost $1
        /usr/lib/rabbitmq/bin/rabbitmqctl add_vhost $1
        /usr/lib/rabbitmq/bin/rabbitmqctl set_permissions -p $1 qa ".*" ".*" ".*"
}

function add_exchange()
{   
    /home/qa-deploy-utils/qa_shell_script/rabbitmq/rabbitmqadmin declare exchange --vhost=$1 name=$2 type=$3 -u qa -p qatest
}


function add_queues()
{   
	echo "增加配置：$2"
	/home/qa-deploy-utils/qa_shell_script/rabbitmq/rabbitmqadmin declare queue --vhost=$1 name=$2 durable=true -u qa -p qatest
}

function add_binding()
{
	echo "增加绑定：从$2到$3"
	/home/qa-deploy-utils/qa_shell_script/rabbitmq/rabbitmqadmin --vhost=$1 declare binding source=$2 destination=$3  routing_key=$4 -u qa -p qatest
}

#ad vhost
add_vhost /
add_vhost /black_hole
add_vhost /funding
add_vhost /loan_order
add_vhost baitiao_debt
add_vhost financial_system
add_vhost feature 
add_vhost mall
add_vhost offline
add_vhost orderstatus_vhost
add_vhost sms
add_vhost spider_center
add_vhost xyqb_push
add_vhost bt_loan
add_vhost baitiao_qrcode
add_vhost bt_loan
add_vhost /pay_center
add_vhost backend
add_vhost baitiao_zhitou
#add exchange
add_exchange /  hello-exchange  direct
add_exchange /black_hole        contract        direct
add_exchange /black_hole        contractExchange        direct
add_exchange /funding   assignment      direct
add_exchange /loan_order        loan_order_exchange     fanout
add_exchange baitiao_debt       baitiaodebt_orderinfo   direct
add_exchange baitiao_debt baitiao_debt direct
add_exchange financial_system   fs      direct
add_exchange mall       digital direct
add_exchange offline    Spider  direct
add_exchange orderstatus_vhost  orderstatus_exchange    direct
add_exchange sms        sms-control     direct
add_exchange xyqb_push  events  direct
add_exchange bt_loan bt_loan_exchange direct
add_exchange baitiao_debt baitiaodebt_orderinfo direct
add_exchange baitiao_qrcode qrcode fanout
add_exchange /pay_center paycenter_exchange direct 
add_exchange backend backend_message_rewrite_exc direct
add_exchange backend backend_file_exc direct
add_exchange /funding async direct
add_exchange spider_center feature_save direct
add_exchange feature feature_save direct
add_exchange baitiao_zhitou btzt_orderStatus_exc direct
add_exchange baitiao_zhitou btzt_repay_rewrite_exc direct
add_exchange baitiao_zhitou btzt_sendfund_exc direct
add_exchange baitiao_zhitou btzt_user_rewrite_exc direct
add_exchange baitiao_zhitou delay_order_approval_query_exchange direct
add_exchange baitiao_zhitou order_approval_query_exchange direct


#add queues
add_queues /black_hole  contractQueue
add_queues /black_hole  generate_success
add_queues /black_hole  ssq_waiting_generate
add_queues /black_hole  waiting_generate
add_queues /black_hole  waiting_oneway
add_queues /funding     approval_suc
add_queues /loan_order  loan_order_queue
add_queues /loan_order  loan_state_msg_queue
add_queues baitiao_debt qunar_baitiaodebt
add_queues baitiao_debt xyqbBaitiaoQueue
add_queues financial_system     baitiaoOrder
add_queues financial_system     baitiaoRefund
add_queues financial_system     loan_info
add_queues financial_system     xyqb
add_queues financial_system     xyqbInfoForRedpacketQueue
add_queues financial_system     xyqbPay
add_queues financial_system     xyqbLoanInfo
add_queues mall deliver
add_queues mall mallOrder
add_queues mall refund
add_queues mall refundFeed
add_queues offline      Test
add_queues orderstatus_vhost    orderstatus_queue
add_queues sms  appMsg
add_queues sms  smsMsg
add_queues sms  confirmMsg
add_queues sms  thirdMsg
add_queues sms  weChatMsg
add_queues sms  smsOpMarket
add_queues spider_center        SpiderSuccess
add_queues spider_center        Test
add_queues xyqb_push    TestEvents
add_queues xyqb_push    myqueue
add_queues mall refund
add_queues mall refundFeed
add_queues financial_system refundInfo
add_queues bt_loan bt_loan_queue
add_queues baitiao_debt save_redpacket
add_queues bt_loan bt_loan_queue
add_queues /black_hole waiting_mult_generate
add_queues financial_system xyqb
add_queues /pay_center withhold_single_service_fee_queue
add_queues /pay_center result_single_service_fee_queue
add_queues backend backend_message_rewrite_queue
add_queues backend backend_file_queue
add_queues /loan_order ka_loan_progress_queue
add_queues /funding generate_contract
add_queues baitiao_debt xyqb_baitiao_queue
add_queues /black_hole generate_auth_success
add_queues /black_hole waiting_auth_generate
add_queues /black_hole generate_register_success
add_queues /black_hole waiting_register_generate
add_queues spider_center feature_calculate
add_queues feature feature_calculate
add_queues baitiao_zhitou btzt_orderStatus_queue
add_queues baitiao_zhitou btzt_repay_rewrite_queue
add_queues baitiao_zhitou btzt_sendfund_queue
add_queues baitiao_zhitou btzt_user_rewrite_queue
add_queues baitiao_zhitou delay_order_approval_query_queue
add_queues baitiao_zhitou dlx_order_approval_query_queue
add_queues baitiao_zhitou order_approval_query_queue

#add bindings
add_binding backend backend_message_rewrite_exc backend_message_rewrite_queue backend_message_rewrite_route
add_binding backend backend_file_exc backend_file_queue backend_file_route
add_binding /black_hole contract generate_auth_success generate_auth_success
add_binding /black_hole contract waiting_auth_generate waiting_auth_generate
add_binding /black_hole contract generate_success generate_success
add_binding /black_hole contract waiting_generate waiting_generate
add_binding /loan_order loan_order_exchange  loan_state_msg_queue loan_state_msg_queue
add_binding baitiao_zhitou btzt_repay_rewrite_exc order_approval_query_queue btzt_repay_rewrite_route
add_binding baitiao_zhitou order_approval_query_exchange  order_approval_query_queue order_approval_query_routing
add_binding baitiao_zhitou delay_order_approval_query_exchange delay_order_approval_query_queue delay_order_approval_query_routing
add_binding baitiao_zhitou btzt_user_rewrite_exc btzt_user_rewrite_queue btzt_user_rewrite_route
add_binding baitiao_zhitou btzt_sendfund_exc btzt_sendfund_queue btzt_sendfund_route
add_binding baitiao_zhitou btzt_repay_rewrite_exc btzt_repay_rewrite_queue btzt_repay_rewrite_route


