#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    db_schema_sync.sh
# Revision:    1.0
# Date:        2016/12
# Author:      dekun.dai
# Description: 实现数据库表结构同步
# -------------------------------------------------------------------------------

source ~/.bash_profile
source ~/.profile

if [ $# -ne 8 ]; then
	echo "---------------"
	echo "source_db_infos：source_db_host: $1, source_db_user: $2"
	echo "target_db_infos：target_db_host: $4, target_db_user: $5"
	echo "sync_db_name: $7, re_replace_ip: $8"
	echo "---参数不正确---"
	echo "Usage:sh db_schema_sync.sh source_db_host source_db_user source_db_pwd target_db_host target_db_user target_db_pwd sync_db_name"
  echo "---------------"
	exit 1
fi

source_db_host=$1
source_db_user=$2
source_db_pwd='Uiwb@o^fR&nHOa5t'

ip_last=$4
target_db_host="192.168.4.$ip_last"
target_db_user=$5
target_db_pwd=$6

sync_db_name=$7
re_replace_ip=$8

work_dir=/home/quant_group/qa-deploy-utils/db-utils
sync_config_folder=/home/db_sync/db_sync_configs
db_backup_folder=/home/db_sync/db_backups

function db_schema_sync()
{	
	database=$1
	uuid=$(uuidgen)
	config_file_name="$sync_config_folder/${database}_${uuid}_db_schema_sync_config.json"
	db_backup_sub_folders=$db_backup_folder/${uuid}
	
	echo "Step 1: generate_config_file: $config_file_name"
	echo "source infos: $source_db_host $source_db_user"
	echo "target infos: $target_db_host $target_db_user"
	echo "database_name is : $sync_db_name"

	sh $work_dir/db_gen_config.sh $source_db_host $source_db_user $source_db_pwd $target_db_host $target_db_user $target_db_pwd $database $config_file_name $db_backup_sub_folders
	
	echo "Step 2: replace domain name in tables: $database $mysql_host $db_backup_sub_folders"
	echo "Step 2.1: is re_replace_ip: $re_replace_ip"
	sh $work_dir/db_replace_ip.sh $database $target_db_host $db_backup_sub_folders $re_replace_ip $ip_last

	echo "Step 3: import basic data from backup file: $database $mysql_host $db_backup_sub_folders"
	sh $work_dir/db_import.sh $database $target_db_host $db_backup_sub_folders
	
	echo "Step 4: sync schema: $database $target_db_host"
	sync_cmd="mysql-schema-sync -conf ${config_file_name} -sync"
	echo "${sync_cmd}"
	$sync_cmd
}

database_list='xyqb xyqb_app payment_center risk_control dujiangyan mall qinqiong quartz contract financial_system gyxd offline sms-center spider_center xyqb_user merchant'
if [[ "$sync_db_name" = "all" ]]
then
	echo "sync all database schema"
	for db_name in $database_list
	do
	    db_schema_sync $db_name
        echo $db_name
	done
else
	db_schema_sync $sync_db_name
fi