# -------------------------------------------------------------------------------
# Filename:    db_replace_ip.sh
# Revision:    1.1
# Date:        2017/02
# Author:      dekun.dai
# Description: 该脚本根据备份sql称特定环境使用的sql
# Usage：used by ../deploy/db_replace_ip.sh
# -------------------------------------------------------------------------------
database_name=$1
server_host=$2
db_sub_backup_folder=$3
re_replace_ip=$4
public_ip="www.liangkebang.com"
ip_last=$5
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

echo $server_host
echo cd $db_sub_backup_folder
cd $db_sub_backup_folder

hosts=`node $config_server/get_project_config.js -type multi -attr port/url -attr2 true`

function transByPort()
{
	if [ -n "$4" ];then
		echo "sed -i \"s/\/$3.xyqb.com/\/$1-$ip_last.liangkebang.com/g\" $4"
		sed -i "s/\/$3.xyqb.com/\/$1-$ip_last.liangkebang.com/g" $4
	fi
}

function transByUrl()
{
	if [ -n "$4" ];then
		echo "sed -i \"s/\/$3.xyqb.com/\/${server_host}:$2/g\" $4"
		sed -i "s/\/$3.xyqb.com/\/${server_host}:$2/g" $4
	fi
}

# function transByPara()
# {
# 	if [ -n "$5" ];then
# 		echo "sed -i \"s/\/$3/\/$5-$3/g\" $4"
# 		sed -i "s/\/$3/\/$5-$3/g" $4
# 	fi
# }

if [ $database_name = 'mall' ];then
	config_table='admin_banner album category_banner faster_entrance life_service loan_config'
	for entry in $config_table
	do
		sed -i "s/https\:/http\:/g" $entry.sql
		if [ "$re_replace_ip" = true ]; then
			echo "replace public ip for $entry.sql"
			for host in $hosts
			do
				arr=${host//|/ }
				transByPort $arr $entry.sql
			done
		elif [ "$re_replace_ip" = false ];then
			echo "replace ip for $entry.sql"
			for host in $hosts
			do
				arr=${host//|/ }
				transByUrl $arr $entry.sql
			done
		else
			echo "replace $re_replace_ip ip for $entry.sql"
			echo "sed -i "s#\.xyqb\.com#-${re_replace_ip}.liangkebang.com#g" $entry.sql"
			sed -i "s#\.xyqb\.com#-${re_replace_ip}.liangkebang.com#g" $entry.sql
		fi
	done
else
	sed -i "s/https\:/http\:/g" $db_sub_backup_folder/*
	if [ "$re_replace_ip" = false ];then
		echo "replace ip for $db_sub_backup_folder/*"
		for host in $hosts
		do
			arr=${host//|/ }
			transByUrl $arr "$db_sub_backup_folder/*"
		done
	elif [ "$re_replace_ip" = true ]; then
		echo "replace public ip for $db_sub_backup_folder/*"
		for host in $hosts
		do
			arr=${host//|/ }
			transByPort $arr "$db_sub_backup_folder/*"
		done
	else
		echo "replace $re_replace_ip ip for $db_sub_backup_folder/*"
		echo "sed -i "s#\.xyqb\.com#-${re_replace_ip}.liangkebang.com#g" $db_sub_backup_folder/*"
		sed -i "s#\.xyqb\.com#-${re_replace_ip}.liangkebang.com#g" $db_sub_backup_folder/*
		#for host in $hosts
		#do
		#	arr=${host//|/ }
		#	transByPara $arr $entry $re_replace_ip
		#done
	fi
fi
