#!/bin/sh
# -------------------------------------------------------------------------------
# Filename:    database_backup.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本从线上从库备份数据库。
# Usage：used by ../deploy/database_sync.sh
# -------------------------------------------------------------------------------
source ~/.bash_profile

database_name=$1
user_name='xyqb_query'
password='Uiwb@o^fR&nHOa5t'
host='192.168.4.253'

db_backup=$2
date_str=`date "+%Y-%m-%d-%H"`
backfilename=${database_name}_back_${date_str}.sql
ingore_tables_str=''

mkdir -p $db_backup

if [[ $database_name = 'xyqb' ]]; then
	# 信用钱包database
	# repay v_manifest v_repay 是view类型的
	# secure_proxy 表里面的数据需要被同步
	sys_table_list='baitiao_merchant baitiao_secure_key channel funding_contract funding_corp loan_product merchant_channel payeco_return_url_info red_packet t_phonenum zmxy_return_url configuration repay v_manifest v_repay secure_proxy'
	port='3306'
elif [[ $database_name = 'xyqb_app' ]]; then
	# app-backend使用的数据库
	sys_table_list='activities app_banners app_config app_versions banners blanknote_entries credit_questions hot_games loan_banners loan_questions migrations sharings widgets js_patch upgrade_version'
	port='3307'
elif [[ $database_name = 'payment_center' ]]; then
	# 支付中心
	sys_table_list='card_switcher merchant merchant_config pay_approach_config'
	port='3308'
elif [[  $database_name = 'risk_control'  ]]; then
	# 谛听database
	sys_table_list='company product_strategy_dispatcher quantify_product red_packet_info socketio_init_parameters user'
	port='3309'
elif [[  $database_name = 'dujiangyan'  ]]; then
	# dujiangyan
	sys_table_list='baitiao_secure_key external_coopr'
	port='3310'
elif [[  $database_name = 'mall'  ]]; then
	# 白条商城
	sys_table_list='mall_config activity_3c_product ad_detail new_3c_product supplier 3c_product 3c_product_spec apix_phone_recharge_detail apix_recharge_project apix_recharge_project_bak category configuration course_detail_info course_info merchant pay19_recharge_project product product_sku product_sku_image product_spu product_nature nature_value'
	port='3310'
elif [[  $database_name = 'qinqiong'  ]]; then
	# qinqiong
	sys_table_list='secure_key secure_proxy'
	port='3310'
elif [[  $database_name = 'quartz'  ]]; then
	# 定时任务
	sys_table_list='certain_time_job'
	port='3310'
elif [[ $database_name = 'contract' ]]; then
	# 合同
	sys_table_list=''
	port='3311'
elif [[  $database_name = 'financial_system'  ]]; then
	# 财务系统
	sys_table_list='collection_user sys_dictionary sys_status_edge sys_status_transfer_data_record sys_status_transfer_record sys_status_vertice'
	port='3311'
elif [[  $database_name = 'gyxd'  ]]; then
	# 广源小贷系统
	sys_table_list='collection_user sys_dictionary sys_status_edge sys_status_transfer_data_record sys_status_transfer_record sys_status_vertice'
	port='3311'
elif [[  $database_name = 'offline'  ]]; then
	# 线下白条
	sys_table_list='goods_detail merchant operator_user'
	port='3311'
elif [[  $database_name = 'sms-center'  ]]; then
	# 短信中心
	sys_table_list='current_index merchant merchant_config sms_content sms_platform'
	port='3311'
elif [[  $database_name = 'spider_center'  ]]; then
	# 授信中心
	sys_table_list='merchant merchant_config notify_message'
	port='3312'
elif [[  $database_name = 'xyqb_user'  ]]; then
	# 用户中心
	sys_table_list='merchant_config merchant'
	port='3313'
elif [[ $database_name = 'merchant' ]]; then
	# 用户中心
	sys_table_list='authority product_nature role role_authority role_supplier user'
	port='3314'
fi

if [ ! -f "$backfilename" ]; then
	echo "$backfilename does not exit, skip remove $backfilename"
else

	echo "rm -f $backfilename"
	rm -f $backfilename
fi


for table_name in $sys_table_list
do
	if [[ $table_name = 'repay' || $table_name = 'v_manifest' || $table_name = 'v_repay' ]]; then
		echo "skip view table $table_name"
	else
		mysqldump -u${user_name} -p${password} -h${host} -P${port} --skip-lock-tables --databases $database_name --tables $table_name >> ${db_backup}/${backfilename}
	fi
	ingore_tables_str+=" --ignore-table=${database_name}.${table_name}"
done
echo $ingore_tables_str

echo "mysqldump -u${user_name} -p${password} -h${host} -P${port} --databases $database_name --no-data $ingore_tables_str >> $backfilename"
mysqldump -u${user_name} -p${password} -h${host} -P${port} --skip-lock-tables --databases $database_name --no-data $ingore_tables_str --skip-add-locks >> ${db_backup}/${backfilename}

\cp -f ${db_backup}/${backfilename} ${db_backup}/${database_name}_latest.sql
