#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    java_deploy.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本调用其他脚本实现java项目的自动化部署。deploy_xyqb，deploy_di-ting等jenkins job使用了该脚本。
# -------------------------------------------------------------------------------

source ~/.bash_profile

echo "部署参数-1：module name: $1, branch name: $2, host address: $3. "
echo "部署参数-2：checkout branch again？$4， build java again？ $5, remote copy again？$6，restart java project? $7, reload configure file? $8."
echo "部署参数-3: allow Picture verification code? ${10}"

module=$1
branch_name=$2
host=$3
checkout_branch=$4
build_java=$5
remote_copy=$6
restart_java=$7
re_load_config=$8
use_pulic_ip=$9
profile=test
close_captcha=${10}

utils_path=/home/quant_group/qa-deploy-utils

if [ "$checkout_branch" = true ]; then
    echo "Step 1: checkout branch: $branch_name"
	sh ${utils_path}/sh-utils/center/1_branch_checkout.sh $branch_name
else
    echo "Step 1: skip checkout branch: $branch_name"
fi


# 增加文件差异对比 2017-01-15 田亚伟
echo "Step 1.1: checkout properties files: "
config_path=`pwd`
expect -c "
spawn scp root@${host}:/home/quant_group/${module}/*.properties ./
expect {
\"*assword\" {
	send \"!QAZ2wsx\n\"
	}
}
expect eof"
echo "------------------------config_fidd:begin------------------------------"
echo `node ${utils_path}/sh-utils/deploy/check_file_diff.js ${config_path}/application.properties /home/quant_group/jenkins/workspace/deploy_${module}/src/main/resources/config/test/`
sed $(echo -e "s/\r//") application.properties > application_last.properties
echo `pwd`
expect -c "
spawn scp ${config_path}/application_last.properties root@${host}:/home/quant_group/${module}/application.properties 
expect {
\"*assword\" {
	send \"!QAZ2wsx\n\"
	}
}
expect eof"
echo "-------------------------config_fidd:end-------------------------------"
# 增加文件差异对比 结束2017-01-15 田亚伟





if [ "$build_java" = true ]; then
    echo "Step 2: build project: $branch_name"
#	sh ${utils_path}/sh-utils/center/2_build_java.sh $profile $module $host $close_captcha
else
    echo "Step 2: skip build project: $branch_name"
fi

if [ "$remote_copy" = true ]; then
    echo "Step 3: remote copy project: "
#	sh ${utils_path}/sh-utils/center/3_remote_copy.sh $module $host java
else
    echo "Step 3: skip remote copy project"
fi

if [ "$restart_java" = true ]; then
	echo "Step 4: restart project: "
#	sh ${utils_path}/sh-utils/center/4_java_restart.sh $module $host "${re_load_config}" "${use_pulic_ip}"
else
    echo "Step 4: skip restart project"
fi


