#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    db_schema_sync.sh
# Revision:    1.0
# Date:        2016/12
# Author:      dekun.dai
# Description: 实现数据库表结构同步
# -------------------------------------------------------------------------------

source ~/.bash_profile

if [ $# -ne 7 ]; then
	echo "---------------"
	echo "source_db_infos：source_db_host: $1, source_db_user: $2"
	echo "target_db_infos：target_db_host: $4, target_db_user: $5"
	echo "sync_db_name: $7"
	echo "---参数不正确---"
	echo "Usage:sh db_schema_sync.sh source_db_host source_db_user source_db_pwd target_db_host target_db_user target_db_pwd sync_db_name"
  echo "---------------"
	exit 1
fi

source_db_host="$1"
source_db_user=$2
source_db_pwd=$3

target_db_host="$4"
target_db_user=$5
target_db_pwd=$6

sync_db_name=$7
date_str=`date "+%Y-%m-%d-%H-%M-%S"`

work_dir=/home/quant_group/test-utils/db-utils
sync_config_folder=~/db_sync_configs
config_file_name="$sync_config_folder/${sync_db_name}_${date_str}_db_schema_sync_config.json"

function db_schema_sync()
{
	echo "Step 1: generate_config_file: $config_file_name"
	echo "source infos: $source_db_host $source_db_user"
	echo "target infos: $target_db_host $target_db_user"
	echo "database_name is : $sync_db_name"
	sh $work_dir/gen_config.sh $source_db_host $source_db_user $source_db_pwd $target_db_host $target_db_user $target_db_pwd $sync_db_name $config_file_name

	echo "Step 2: sync schema: $database $mysql_host"
	sync_cmd="mysql-schema-sync -conf ${config_file_name} -sync"
	echo "${sync_cmd}"
	$sync_cmd
}

database_list='xyqb xyqb_app payment_center risk_control dujiangyan mall qinqiong quartz contract financial_system gyxd offline sms-center spider_center'
if [[ "${database_name}" = "all" ]]
then
	echo "all database"
	for database in $database_list
	do
	    db_schema_sync $database
        echo $database
	done
else
	db_schema_sync $database_name
fi