#!/bin/sh
# -------------------------------------------------------------------------------
# Filename:    gen_config.sh
# Revision:    1.0
# Date:        2016/12
# Author:      dekun.dai
# Description: 生成一个同步表结构用的配置文件
# -------------------------------------------------------------------------------
source ~/.bash_profile

source_db_host=$1
source_db_user=$2
source_db_pwd=$3

target_db_host=$4
target_db_user=$5
target_db_pwd=$6

sync_db_name=$7
database_name=$sync_db_name

config_file_name=$8
port=""
sync_config_folder=~/db_sync_configs
base_config_file=$sync_config_folder/base_config.json

if [ $# -ne 8 ]; then
	echo "gen_config.sh"
	echo "Total Number of Parameters : $#"
	echo "source_db_infos：source_db_host: $1, source_db_user: $2"
	echo "target_db_infos：target_db_host: $4, target_db_user: $5"
	echo "sync_db_name: $7"
	echo "config_file_name: $8"
	exit 1
fi

echo "prepare to get port"
if [[ $database_name = 'xyqb' ]]; then
	# 信用钱包database
	# repay v_manifest v_repay 是view类型的
	# secure_proxy 表里面的数据需要被同步
	sys_table_list='baitiao_merchant baitiao_secure_key channel funding_contract funding_corp loan_product merchant_channel payeco_return_url_info red_packet t_phonenum zmxy_return_url configuration repay v_manifest v_repay secure_proxy'
	port='3306'
elif [[ $database_name = 'xyqb_app' ]]; then
	# app-backend使用的数据库
	sys_table_list='activities app_banners app_config app_versions banners blanknote_entries credit_questions hot_games loan_banners loan_questions migrations sharings widgets'
	port='3307'
elif [[ $database_name = 'payment_center' ]]; then
	# 支付中心
	sys_table_list='card_switcher merchant merchant_config pay_approach_config'
	port='3308'
elif [[  $database_name = 'risk_control'  ]]; then
	# 谛听database
	sys_table_list='company product_strategy_dispatcher quantify_product red_packet_info socketio_init_parameters user'
	port='3309'
elif [[  $database_name = 'dujiangyan'  ]]; then
	# dujiangyan
	sys_table_list='baitiao_secure_key external_coopr'
	port='3310'
elif [[  $database_name = 'mall'  ]]; then
	# 白条商城
	sys_table_list='activity_3c_product ad_detail new_3c_product supplier 3c_product 3c_product_spec apix_phone_recharge_detail apix_recharge_project apix_recharge_project_bak category configuration course_detail_info course_info merchant pay19_recharge_project product'
	port='3310'
elif [[  $database_name = 'qinqiong'  ]]; then
	# qinqiong
	sys_table_list='secure_key secure_proxy'
	port='3310'
elif [[  $database_name = 'quartz'  ]]; then
	# 定时任务
	sys_table_list='certain_time_job'
	port='3310'
elif [[ $database_name = 'contract' ]]; then
	# 合同
	sys_table_list=''
	port='3311'
elif [[  $database_name = 'financial_system'  ]]; then
	# 财务系统
	sys_table_list='collection_user sys_dictionary sys_status_edge sys_status_transfer_data_record sys_status_transfer_record sys_status_vertice'
	port='3311'
elif [[  $database_name = 'gyxd'  ]]; then
	# 广源小贷系统
	sys_table_list='collection_user sys_dictionary sys_status_edge sys_status_transfer_data_record sys_status_transfer_record sys_status_vertice'
	port='3311'
elif [[  $database_name = 'offline'  ]]; then
	# 线下白条
	sys_table_list='goods_detail merchant operator_user'
	port='3311'
elif [[  $database_name = 'sms-center'  ]]; then
	# 短信中心
	sys_table_list='current_index merchant merchant_config sms_content sms_platform'
	port='3311'
elif [[  $database_name = 'spider_center'  ]]; then
	# 授信中心
	sys_table_list='merchant merchant_config'
	port='3312'
elif [[  $database_name = 'xyqb_user'  ]]; then
	# 用户中心
	sys_table_list='merchant_config merchant'
	port='3313'
elif [[ $database_name = 'merchant' ]]; then
	# 用户中心
	sys_table_list='authority product_nature role role_authority role_supplier user'
	port='3314'
fi

echo "port is $port"
echo "copy ${base_config_file} to ${config_file_name}"
cp -f $base_config_file $config_file_name

echo "sed -i s/source_db_host/${source_db_host}/g $config_file_name" 
sed -i "s/source_db_host/${source_db_host}/g" $config_file_name
sed -i "s/source_db_user/${source_db_user}/g" $config_file_name
sed -i "s/source_db_pwd/${source_db_pwd}/g" $config_file_name
sed -i "s/target_db_host/${target_db_host}/g" $config_file_name
sed -i "s/target_db_user/${target_db_user}/g" $config_file_name
sed -i "s/target_db_pwd/${target_db_pwd}/g" $config_file_name
sed -i "s/sync_db_name/${sync_db_name}/g" $config_file_name
sed -i "s/source_port/${port}/g" $config_file_name