# -------------------------------------------------------------------------------
# Filename:    java_deploy.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本负责build java项目。
# Usage：used by ../deploy/java_deploy.sh
# -------------------------------------------------------------------------------
source /etc/profile

config_profile=$1
module=$2
host=$3
close_captcha=$4

echo $close_captcha
if [[ "${host}" = "192.168.10.2" ]]
then 
	suffix=''
	echo "skip get suffix"
else
	suffix=$((${host:10}+1))
	echo $host $suffix
fi

if [ -z $config_profile ]; then
    echo "Does not set config profile, use the default value: test"
    ${config_profile}=test
else
    echo "use specified profile $config_profile"
fi

if [[ "$module" = "han-gu-guan" ]] && $close_captcha; then
	echo "关闭验证码"
	num=`grep -n "Boolean validCaptcha" src/main/java/cn/quantgroup/xyqb/aspect/captcha/CaptchaValidateAdvisor.java|awk -F ':' '{print $1}'`
	sed -i "${num}s/false/true/"  src/main/java/cn/quantgroup/xyqb/aspect/captcha/CaptchaValidateAdvisor.java
	num1=`expr ${num} + 1`
	num6=`expr ${num} + 7`
	echo "注释掉第${num1}行到${num6}行"
	sed -i "${num1}i/*"  src/main/java/cn/quantgroup/xyqb/aspect/captcha/CaptchaValidateAdvisor.java
	sed -i "${num6}i*/"  src/main/java/cn/quantgroup/xyqb/aspect/captcha/CaptchaValidateAdvisor.java
fi



if [[ "$module" = "xyqb" || "$module" = "pay-center" || "$module" = "han-gu-guan" || "$module" = "di-ting" || "$module" = "xyqb-offline" || "$module" = "xyqb-user" ]]; then
	echo "module is ${module}, need replace sms jar version from 1.0.x to 1.0.2"
	num=`grep -n  -A12 "<id>test</id>"  pom.xml| grep "<version>" | awk -F- '{print $1}'`
	if [[ "$host" = "192.168.10.2" ]]; then
		sed -i  ''$num's/1.0.[0-9]-SNAPSHOT/1.0.2-SNAPSHOT/'  pom.xml
	else
		sed -i  "${num}s/1.0.[0-9]-SNAPSHOT/1.0.6-SNAPSHOT/"  pom.xml
	fi
fi

if [[ "$module" = "du-jiang-yan" ]]; then
	num=`grep -n  -A3 "<artifactId>fund-manage-sdk</artifactId>"  pom.xml| grep "<version>" | awk -F- '{print $1}'`
	sed -i  "${num}s/1.0.[0-9]-SNAPSHOT/1.0.0.${suffix}-SNAPSHOT/"  pom.xml
	sed -i  "${num}s/1.0.[0-9].[0-9]/1.0.0.${suffix}-SNAPSHOT/"  pom.xml
fi

echo "mvn clean package -P${config_profile} -Dmaven.test.skip=true"
mvn clean package -P${config_profile} -Dmaven.test.skip=true -X

mkdir -p /home/quant_group/deploy_backup
\cp -f target/*.jar /home/quant_group/deploy_backup/
exit $?
