# -------------------------------------------------------------------------------
# Filename:    java_deploy.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本通过远程调用工作机器的脚本，来实现java项目的start和stop。
# Usage：used by ../deploy/java_deploy.sh
# -------------------------------------------------------------------------------
echo "java_restart.sh parameter: module_name: ${1}, host: ${2}, re_load_config: ${3}"
module_name=$1
host=$2
re_load_config=$3
use_pulic_ip=$4
port=22
user="root"
password="!QAZ2wsx"
package_path="/home/quant_group/${module_name}"
shutils_path="/home/quant_group/test-utils/sh-utils"

ack_phrase="Started\ Bootstrap"
max_wait_log_generate_time=50
max_wait_ack_time=500

if [[ "${module_name}" = "di-ting" ]]
then 
	log_path=/home/quant_group/logs/di_ting.log
elif [[ "${module_name}" = "jian-men-guan" ]]
then 
	log_path=/home/quant_group/logs/jian_men_guan.log
elif [[ "${module_name}" = "du-jiang-yan" ]]
then 
	log_path=/home/quant_group/logs/du_jiang_yan.log
elif [[ "${module_name}" = "financial-system" ]]
then 
	log_path=/home/quant_group/logs/financial_system.log
elif [[ "${module_name}" = "xyqb-offline" ]]
then 
	log_path=/home/quant_group/logs/xyqb_offline.log
elif [[ "${module_name}" = "red-packet" ]]
then 
	log_path=/home/quant_group/logs/redpacket.log
elif [[ "${module_name}" = "fund-manage" ]]
then 
	log_path=/home/quant_group/logs/fund_manage.log
elif [[ "${module_name}" = "cash-loan-flow" ]]
then 
	log_path=/home/quant_group/logs/cash_loan_flow.log
elif [[ "${module_name}" = "xyqb-user" ]]
then 
	log_path=/home/quant_group/logs/xyqb_user.log
else
	log_path=/home/quant_group/logs/${module_name}.log
fi

echo "Step 4.1 stop java"
ssh root@${host} sh ${shutils_path}/worker/java_stop.sh ${module_name}
sleep 5
if [ $? -ne 0 ]
then
    echo "Fail to stop"
fi

timestamp_log=`date +%Y-%m-%d.%H%M%S`
echo "Step 4.2 backup log"
ssh root@${host} mv ${log_path} ${log_path}.${timestamp_log}

echo "Step 4.3 start java"
ssh root@${host} sh ${shutils_path}/worker/java_start.sh ${module_name} $host "${re_load_config}" "${use_pulic_ip}"
if [ $? -ne 0 ]
then
   echo "Fail to start"
fi

echo "Step 4.4 check logs：waiting for ${ack_phrase}"
ssh root@${host} sh ${shutils_path}/worker/log_check.sh "${ack_phrase}" ${log_path} ${max_wait_log_generate_time} ${max_wait_ack_time}
