#!/bin/sh
jenkins_host=192.168.192.191
target_host=$target_host
module_name=test-utils

mkdir -p /home/quant_group/deploy_backup
backup_path=/home/quant_group/deploy_backup


echo job name is ${module_name}
if [ -f ${backup_path}/${module_name}.tar.gz ]
then
	rm ${backup_path}/${module_name}.tar.gz
fi

# 
echo tar cfz ${backup_path}/${module_name}.tar.gz ../${JOB_NAME}
tar cfz ${backup_path}/${module_name}.tar.gz ../${JOB_NAME}

if [ -f  ${backup_path}/${JOB_NAME} ]
then
	rm -rf ${backup_path}/${JOB_NAME}
fi
tar zxf ${backup_path}/${JOB_NAME}.tar.gz -C ${backup_path}/${JOB_NAME}



function copy_to()
{
	host=$1
	scp /home/quant_group/deploy_backup/${module_name}.tar.gz root@${host}:/home/quant_group/deploy_backup/
}

if [[ "${target_host}" = "ALL" ]]
then
	hosts='di-ting du-jiang-yan han-gu-guan jian-men-guan mall pay-center quartz xyqb'
	for host in $hosts
	do
	    copy_to ${host}
        echo ${host}
	done
elif [[ "${target_host}" = "" ]]
then
   echo 'Fail module name is empty'
   exit -1
else
	copy_to ${target_host}
 	echo ${target_host}
fi