#!/bin/bash

function add_vhost()
{       
        /usr/lib/rabbitmq/bin/rabbitmqctl add_vhost $1
        /usr/lib/rabbitmq/bin/rabbitmqctl set_permissions -p $1 qa ".*" ".*" ".*"
}

function add_exchange()
{   
    /home/qa-deploy-utils/qa_shell_script/rabbitmq/rabbitmqadmin declare exchange --vhost=$1 name=$2 type=$3 -u qa -p qatest
}


function add_queues()
{   
    /home/qa-deploy-utils/qa_shell_script/rabbitmq/rabbitmqadmin declare queue --vhost=$1 name=$2 durable=true -u qa -p qatest
}


#ad vhost
add_vhost /
add_vhost /black_hole
add_vhost /funding
add_vhost /loan_order
add_vhost baitiao_debt
add_vhost financial_system
add_vhost mall
add_vhost offline
add_vhost orderstatus_vhost
add_vhost sms
add_vhost spider_center
add_vhost xyqb_push
add_vhost bt_loan

#add exchange
add_exchange /  hello-exchange  direct
add_exchange /black_hole        contract        direct
add_exchange /black_hole        contractExchange        direct
add_exchange /funding   assignment      direct
add_exchange /loan_order        loan_order_exchange     fanout
add_exchange baitiao_debt       baitiaodebt_orderinfo   direct
add_exchange financial_system   fs      direct
add_exchange mall       digital direct
add_exchange offline    Spider  direct
add_exchange orderstatus_vhost  orderstatus_exchange    direct
add_exchange sms        sms-control     direct
add_exchange xyqb_push  events  direct
add_exchange bt_loan bt_loan_exchange direct

#add queues
add_queues /black_hole  contractQueue
add_queues /black_hole  generate_success
add_queues /black_hole  ssq_waiting_generate
add_queues /black_hole  waiting_generate
add_queues /black_hole  waiting_oneway
add_queues /funding     approval_suc
add_queues /loan_order  loan_order_queue
add_queues baitiao_debt qunar_baitiaodebt
add_queues baitiao_debt xyqbBaitiaoQueue
add_queues financial_system     baitiaoOrder
add_queues financial_system     baitiaoRefund
add_queues financial_system     loan_info
add_queues financial_system     xyqb
add_queues financial_system     xyqbInfoForRedpacketQueue
add_queues financial_system     xyqbPay
add_queues mall deliver
add_queues mall mallOrder
add_queues mall refund
add_queues mall refundFeed
add_queues offline      Test
add_queues orderstatus_vhost    orderstatus_queue
add_queues sms  confirm
add_queues sms  confirmable
add_queues sms  send
add_queues sms  voiceconfirm
add_queues sms  voiceconfirmable
add_queues spider_center        SpiderSuccess
add_queues spider_center        Test
add_queues xyqb_push    TestEvents
add_queues xyqb_push    myqueue
add_queues mall refund
add_queues mall refundFeed
add_queues financial_system refundInfo
add_queues bt_loan bt_loan_queue

