#!/bin/bash
project_type=$1
is_public_ip=$2
ip=$3
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

trap "exec 1000>&-;exec 1000<&-;exit 0" 2
tempfifo=$$.fifo
echo "mkfifo /tmp/$tempfifo"
mkfifo /tmp/$tempfifo
exec 1000<>/tmp/$tempfifo
rm -rf /tmp/$tempfifo

function buildNginx()
{
	# 第二步   不关机使得nginx生效
	sh $config_server/show_info.sh nginx.config_d "打包BUILD" nginx配置文件生效 $2
	nginx -t;  nginx -s reload
}

if [ "$project_type" = "java" ]; then
	for ((i=1; i<=4; i++))
	do
		echo >&1000
	done
	java_projects=(`node $config_server/get_project_config.js  -type java -attr name`)
	for project_name in ${java_projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/buildJava.sh $project_name $config_server $project_path
			# buildJavaProject $project
			echo >&1000
		}&
	done
	wait
elif [ "$project_type" = "ui" ]; then
	for ((i=1; i<=8; i++))
	do
		echo >&1000
	done
	ui_projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
	for project_name in ${ui_projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/buildUi.sh $project_name $config_server $project_path
			# buildUiProject $project
			echo >&1000
		}&
	done
	wait
	buildNginx
elif [ "$project_type" = "node" ]; then
	for ((i=1; i<=8; i++))
	do
		echo >&1000
	done
	node_projects=(`node $config_server/get_project_config.js  -type node -attr name`)
	for project_name in ${node_projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/buildNode.sh $project_name $config_server $project_path
			# buildNodeProject $project
			echo >&1000
		}&
	done
	wait
elif [ "$project_type" = "python" ]; then
	python_projects=(`node $config_server/get_project_config.js  -type python -attr name`)
	for project_name in ${python_projects[@]}
	do
		sh $pwd_path/base_script/buildPython.sh $project_name $config_server $project_path
		# buildPythonProject $project
	done
else
	for ((i=1; i<=5; i++))
	do
		echo >&1000
	done
	java_projects=(`node $config_server/get_project_config.js  -type java -attr name`)
	for project_name in ${java_projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/buildJava.sh $project_name $config_server $project_path
			# buildJavaProject $project $ip
			echo >&1000
		}&
	done
	python_projects=(`node $config_server/get_project_config.js  -type python -attr name`)
	for project_name in ${python_projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/buildPython.sh $project_name $config_server $project_path
			# buildPythonProject $project $ip
			echo >&1000
		}&
	done
	node_projects=(`node $config_server/get_project_config.js  -type node -attr name`)
	for project_name in ${node_projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/buildNode.sh $project_name $config_server $project_path
			# buildNodeProject $project $ip
			echo >&1000
		}&
	done
	ui_projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
	for project_name in ${ui_projects[@]}
	do
		read -u1000
		{
			sh $pwd_path/base_script/buildUi.sh $project_name $config_server $project_path
			# buildUiProject $project $ip
			echo >&1000
		}&
	done
	wait
	buildNginx
fi
