#!/bin/sh

java_modules='di-ting du-jiang-yan han-gu-guan jian-men-guan mall pay-center quartz xyqb'
ui_modules='di-ting-ui xyqb-ui pay-center-ui'

if [[ "${module_type}" = "java" ]]
then
	modules=$java_modules
else
	modules=$ui_modules
fi

mkdir -p  /home/quant_group/deploy_backup

function clean_backup()
{
	module=$1
	mkdir -p  /home/quant_group/deploy_backup/${module}
	echo cd /home/quant_group/deploy_backup/${module}
	cd  /home/quant_group/deploy_backup/${module}
	rm -rf *
}

if [[ "${module_name}" = "ALL" ]]
then
	for module in $modules
	do
	    clean_backup ${module}
        echo clean_backup ${module}
	done
elif [[ "${module_name}" = "" ]]
then
   echo 'Fail module name is empty'
   exit -1
else
	clean_backup ${module_name}
 	echo clean_backup ${module_name}
fi