#!/bin/bash
set -u
source ~/.profile
work_dir=/home/qa-deploy-utils/db-utils
sync_config_folder=/home/quant_group/db_sync_configs
db_backup_folder=/home/quant_group/daily_db_backup

source_db_host=$1
source_db_user=`curl -s http://192.168.4.3:10088/config_server/get_db_config/xyqb/username`
source_db_pwd=`curl -s http://192.168.4.3:10088/config_server/get_db_config/xyqb/passwd`

target_db_host=192.168.6.2
target_db_port=3306

target_db_user=$5
target_db_pwd=$6

sync_db_name=$7

function db_schema_sync()
{
	database=$1
	uuid=$(uuidgen)
	config_file_name="$sync_config_folder/${database}_${uuid}_db_schema_sync_config.json"
	db_backup_sub_folders=$db_backup_folder/${database}
	
	echo "mkdir -p $db_backup_sub_folders"
	mkdir -p $db_backup_sub_folders
	mkdir -p $sync_config_folder
	
	echo "--- Step 1: generate_config_file: $config_file_name ---"
	# echo "source infos: $source_db_host $source_db_user"
	# echo "target infos: $target_db_host $target_db_user"
	# echo "database_name is : $sync_db_name"

	echo "sh $work_dir/db_gen_config.sh $source_db_host $source_db_user $source_db_pwd $target_db_host $target_db_user $target_db_pwd $database $config_file_name $db_backup_sub_folders false 3306"
	sh $work_dir/db_gen_config.sh $source_db_host $source_db_user $source_db_pwd $target_db_host $target_db_user $target_db_pwd $database $config_file_name $db_backup_sub_folders false 3306

	# echo "--- Step 3: sync schema: $database $target_db_host ---"
	# #sync_cmd="mss -conf ${config_file_name} -sync"
	# echo "mss -conf ${config_file_name} -sync > /dev/null"
	# mss -conf ${config_file_name} -sync > /dev/null
	# echo "mysql-schema-sync result:$?"

	# echo "--- Step 4: import basic data from backup file: $database $db_backup_sub_folders ---"
	# sh $work_dir/db_import.sh $database $target_db_host $db_backup_sub_folders $target_db_port
}

database_list=`curl -s http://192.168.4.3:10088/config_server/get_db_config/all/name`
echo "database_list:${database_list}"

for db_name in $database_list
do
	echo "----------------------------------------------------"
	echo "--- start sync $db_name ---"
	db_schema_sync $db_name
	echo "--- end sync $db_name ---"
done
echo "----------------------------------------------------"
