# -------------------------------------------------------------------------------
# Filename:    db_execute_sql.sh
# Revision:    1.0
# Date:        2017/03
# Author:      dekun.dai
# Description: 执行目录下所有数据库脚本
# -------------------------------------------------------------------------------

mysql_host=$1
db_name=$2
target_db_port=$3
sql_file_folder=/home/qa-deploy-utils/db-utils/sql_to_run

echo "cd $sql_file_folder"
cd $sql_file_folder
if [ -n "$db_name" ];then
    if [ -f $db_name.sql ];then
        echo "mysql -h $mysql_host -P $target_db_port -uqa -pqatest $db_name < $db_name.sql"
        mysql -h $mysql_host -P $target_db_port -uqa -pqatest $db_name < $db_name.sql
    else
        echo "have no $db_name.sql"
    fi
else
    for entry in ./*
    do
        echo "run sql file: $entry"
        mysql -h $mysql_host -P $target_db_port -uqa -pqatest < $entry
    done
fi

dropSQL=`curl -s -m 5 http://qaapi.liangkebang.com/dbsync/getDropSQL?dbName=${db_name}`
echo "dropSQL: ${dropSQL}"
if [ -n "$dropSQL" ];then
    echo "mysql -h $mysql_host -P $target_db_port -uqa -pqatest $db_name -e ${dropSQL}"
    mysql -h $mysql_host -P $target_db_port -uqa -pqatest $db_name -e "${dropSQL}"
fi

