var project_name, project_attr, projects = {},
	java_projects = [],
	node_projects = [],
	python_projects = [],
	ui_projects = [];
var param = {
	type: "",
	name: "",
	attr: ""
}
var users = [{}, {
	name: "dekun.dai",
	pwd: "quantgroup.com"
}, {
	name: "shengcong.gan",
	pwd: "12345678"
}];

var pClass = function() {};
pClass.prototype = {
		init: function(isActive, projectType, port, projectName, gitPath, logName, configFile, command, nodeVersion, userIndex, desc,auth) {
			this.name = projectName;
			this.type = projectType;
			this.git_path = "http://" + users[userIndex].name + ":" + users[userIndex].pwd + "@gitabc.xyqb.com/" + gitPath + "/" + projectName + ".git"
			this.log_name = logName;
			this.config_file = configFile;
			this.command = command;
			this.node_version = nodeVersion;
			this.port = port;
			this.desc = desc;
			this.is_active = isActive;
			this.auth = auth;
			projects[projectName] = this;
			switch (projectType) {
				case "java":
					java_projects.push(this);
					break;
				case "node":
					node_projects.push(this);
					break;
				case "ui":
					ui_projects.push(this);
					break;
				case "python":
					python_projects.push(this);
					break;
			}
		}
	}
	// projectName,projectType,port,gitPath,logName,configFile,command,nodeVersion
new pClass().init(true, "java", "7003", "xyqb", "QG", "xyqb.log", "application.properties", null, null, 2, "现金贷和白条-server");
new pClass().init(true, "java", "7019", "xyqb-mall", "QG", "mall.log", "application.properties", null, null, 2, "商城后台-server");
new pClass().init(true, "java", "7010", "xyqb-offline", "QG", "xyqb_offline.log", "application.properties", null, null, 2, "线下业务-server");
new pClass().init(true, "java", "7042", "xyqb-user2", "head_group", "xyqb_user.log", "application.properties", null, null, 2, "用户注册登录-V2-server");
new pClass().init(true, "java", "7005", "di-ting", "QG", "di_ting.log", "application.properties", null, null, 2, "风控审计-server");
new pClass().init(true, "java", "7013", "han-gu-guan", "QG", "han-gu-guan.log", "application.properties", null, null, 2, "用户注册登录-V1-server");
new pClass().init(true, "java", "7015", "jian-men-guan", "QG", "jian_men_guan.log", "application.properties", null, null, 2, "信审服务-server");
new pClass().init(true, "java", "7028", "black-hole", "QG", "black-hole.log", "application.properties", null, null, 2, "合同中心-server"); 
new pClass().init(true, "java", "7006", "gu-bei", "QG", "pay-center.log", "application.properties", null, null, 2, "支付中心-server"); 
new pClass().init(true, "java", "7023", "xyqb-quartz", "QG", "quartz.log", "application.properties", null, null, 2, "定时任务-server");
new pClass().init(true, "java", "7021", "spider-center", "QG", "spider-center.log", "application.properties", null, null, 2, "授信-server");
new pClass().init(true, "java", "7037", "cash-loan-flow", "QG", "cash_loan_flow.log", "application.properties", null, null, 2, "现金贷流量对接-server");
new pClass().init(true, "java", "7012", "financial-system", "QG", "financial_system.log", "application.properties", null, null, 2, "财务系统-server");
new pClass().init(true, "java", "7034", "fund-manage", "QG", "fund_manage.log", "application.properties", null, null, 2, "债转系统-server");
new pClass().init(true, "java", "7029", "gyxd", "QG", "gyxd.log", "application.properties", null, null, 2, "广源小贷-server");
new pClass().init(true, "java", "7038", "merchant-backend", "QG", "merchant.log", "application.properties", null, null, 2, "商户后台-server","凌子华／陈东亮");
new pClass().init(true, "java", "7031", "redpacket", "QG", "redpacket.log", "application.properties", null, null, 2, "红包系统-server");
new pClass().init(true, "java", "7044", "finance-api", "bo.wang", "finance-api.log", "application.properties", null, null, 2, "财务系统-server");
new pClass().init(true, "java", "7045", "check-accounts", "QG", "check_accounts.log", "application.properties", null, null, 2, "对账系统-server");
new pClass().init(true, "java", "7014", "du-jiang-yan", "QG", "du_jiang_yan.log", "application.properties", null, null, 2, "第三方对接-server");
// new pClass(true,"java","7027","sms-center","QG","sms-center.log",null,null,null,"短信中心-server");
// ui----
// projectName,projectType,port,gitPath,logName,configFile,command,nodeVersion
new pClass().init(true, "ui", "7032", "op-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", 1, "运营系统-ui");
new pClass().init(true, "ui", "7040", "activity-ui", "QG", null, "src/app/config.js", "npm run build", "node7", 1, "活动中心-ui");
new pClass().init(true, "ui", "7011", "financial-system-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", 1, "财务系统-ui");
new pClass().init(true, "ui", "7030", "gyxd-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", 1, "广源小贷-ui");
new pClass().init(true, "ui", "7008", "offline-ui", "QG", null, "src/app/config/env.config.js", "npm run build", "node7", 1, "线下白条-ui");
new pClass().init(true, "ui", "7035", "funding-corp-op-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", 1, "白条债转系统-ui");
new pClass().init(true, "ui", "7007", "paycenter-ui", "QG", null, "src/app/config/env.config.js", "npm run build", "node7", 1, "支付中心-ui");
new pClass().init(true, "ui", "7043", "xyqb-user-ui", "head_group", null, "src/app/config.js", "npm run qa", "node7", 1, "用户注册登录-V2-ui");
new pClass().init(true, "ui", "7039", "merchant-op-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", 1, "商户系统-ui");
new pClass().init(true, "ui", "7004", "di-ting-ui", "QG", null, "client/app/config.js", "grunt build", "node4", 1, "信审-ui");
new pClass().init(true, "ui", "7020", "spider-center-ui", "QG", null, "src/app/config/env.config.js", "npm run qa", "node7", 1, "授信中心-ui");
new pClass().init(true, "ui", "7002", "qgbc-ui", "QG", null, "src/app/config/env.config.js", "npm run build_production", "node7", 1, "现金贷和白条-白条-ui");
new pClass().init(true, "ui", "7001", "xyqb-ui", "QG", null, "client/app/config.js", "grunt build", "node4", 1, "现金贷和白条-现金贷-ui");
new pClass().init(true, "ui", "7046", "activity-op-ui", "QG", null, "src/js/env.config.js", "gulp build", "node7", 1, "优惠券管理后台-ui");
// node
new pClass().init(true, "node", "7018", "AppBackend", "QG", null, "config/environment/test.js", null, null, 1, "APP后台服务-server");
new pClass().init(true, "node", "7041", "activity-op", "QG", null, "src/config.js", null, null, 1, "优惠券中心-server");
new pClass().init(true, "node", "9050", "op-api", "OP", null, "src/config.js", null, null, 1, "系统Api Gateway-server");
//python
new pClass().init(true, "python", "7022", "qin-qiong", "QG", null, "config/beta/config.properties", null, null, 1, "加密解密-server");
new pClass().init(true, "python", "7033", "xyqb-query", "QG", null, "server/config/beta/config.ini", null, null, 1, "query-server");
new pClass().init(false, "python", "7027", "msg-center", "QG", null, "server/config/beta/config.ini", null, null, 1, "短信中心-以前的sms-center");

var temp = "";

process.argv.forEach(function(val, index, array) {
	if (index >= 2) {
		if (index % 2 == 0) {
			temp = val.replace(/\-/, "");
			param[temp] = "";
		} else {
			param[temp] = val;
		}
	}
});

function getListAttr(projects, attr) {
	var list = [];
	for (var i = 0; i < projects.length; i++) {
		if(projects[i].is_active){
			list.push(projects[i][attr])
		}
	}
	return list.join(" ");
}
var configFunction = function() {};
configFunction.prototype = {
	getProjectAttr: function(pName, pAttr) {
		if (typeof projects[pName] == "undefined") {
			console.log("")
		} else {
			if (typeof projects[pName][pAttr] == "undefined") {
				console.log("")
			} else {
				if(projects[pName][pAttr]){
					console.log(projects[pName][pAttr])
				}else{
					console.log("")
				}
				
			}
		}
	},
	getProjectsAttr: function(type, attr) {
		switch (type) {
			case "java":
				console.log(getListAttr(java_projects, attr));
				break;
			case "ui":
				console.log(getListAttr(ui_projects, attr));
				break;
			case "python":
				console.log(getListAttr(python_projects, attr));
				break;
			case "node":
				console.log(getListAttr(node_projects, attr));
				break;
		}
	}
}
var F = new configFunction();

if (param["type"] == "") {
	F.getProjectAttr(param["name"], param["attr"]);
} else {
	F.getProjectsAttr(param["type"], param["attr"]);
}
