#!/bin/bash
project=$1
config_server=$2
project_path=$3
ip=$4
node4_path=`cat $config_server/node_4_path.sh`
node7_path=`cat $config_server/node_7_path.sh`

params=`node $config_server/get_project_config.js  -name $project -attr desc/config_file/command/node_version`
params_arry=(${params//|/ })

desc=${params_arry[0]}
config_file=${params_arry[1]}
command=${params_arry[2]//\^/ }
node_version=${params_arry[3]}


sh $config_server/show_info.sh $project BUILD $desc $ip
# 第一步  将nginx项目的所有文件进行打包
cd $project_path/$project

package_check_file=`find ./ -maxdepth 1 -name "package.json"`
if [ -n "$package_check_file" ];then
	item=`diff -qrs package.json package_diff.json`
	if [[ $item =~ "identical" ]]; then
		echo "本次package无变更"
	else
		echo "本次package有变更，将要执行npm install"
		#if [ "$node_version" = "node4" ] ;then
		#	echo "node-V4-${node4_path}/npm install"
		#	${node4_path}/npm  --registry http://172.16.3.15:4873 install
		#else
		#	npm --registry http://172.16.3.15:4873 install
		#fi
		if [ $project = 'cuishou-ui-new' ];then
			echo "npm --registry http://registry.npm.taobao.org install"
			npm --registry http://registry.npm.taobao.org install
		else
			echo "npm --registry http://172.16.3.15:4873 install"
			npm --registry http://172.16.3.15:4873 install
		fi
	fi
fi

yes | cp package.json package_diff.json

bower_json=`find ./ -maxdepth 1 -name "bower.json"`

if [ -n "$bower_json" ];then
	echo "执行  bower install --allow-root"
	bower install --allow-root
else
	echo "没有bower，不需要执行"
fi

echo "$command"
$command
if [ $? != 0 ];then
        exit -1
fi
# 第二步   不关机使得nginx生效
#nginx -t;  nginx -s reload
