#!/bin/bash
date
project_type=$1
branch_name=$2
public_ip=$3
ip=$4

pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`
if [ "$project_type" = "all" ]
then
	projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
        echo ${#projects[@]}"个ui项目:"  ${projects[@]}
	projects=(`node $config_server/get_project_config.js  -type java -attr name`)
        echo ${#projects[@]}"个java项目:"  ${projects[@]}
	projects=(`node $config_server/get_project_config.js  -type node -attr name`)
        echo ${#projects[@]}"个node项目:"  ${projects[@]}
	projects=(`node $config_server/get_project_config.js  -type python -attr name`)
        echo ${#projects[@]}"个python项目:"  ${projects[@]}
else
	projects=(`node $config_server/get_project_config.js  -type $1 -attr name`)
	echo ${#projects[@]}"个"$1"项目:"  ${projects[@]}
fi
echo "sh 2_get_code_by_type.sh $project_type $branch_name $ip"
sh 2_get_code_by_type.sh $project_type $branch_name $ip
echo "sh 3_link_config_file_by_type.sh $project_type $public_ip $ip"
sh 3_link_config_file_by_type.sh $project_type $public_ip $ip
echo "sh 4_build_by_type.sh $project_type $public_ip $ip"
sh 4_build_by_type.sh $project_type $public_ip $ip
echo "sh 5_restart_by_type.sh $project_type $public_ip $ip"
sh 5_restart_by_type.sh $project_type $public_ip $ip
date
