#!/bin/bash
project=$1
is_public_ip=$2
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

if  [ "$project" = "nginx" ]
then
		sh $config_server/show_info.sh nginx.conf_d 连接配置文件 nginx配置文件 $3
		rm -rf /etc/nginx/conf.d
		ln -s $config_path/nginx_conf.d /etc/nginx/conf.d
		nginx -t;  nginx -s reload
elif [ -n "$project" ]
then
	desc=`node $config_server/get_project_config.js  -name $project -attr desc`
	sh $config_server/show_info.sh $project 连接配置文件 $desc $3
	project_type=`node $config_server/get_project_config.js  -name $project -attr type`
	file=`node $config_server/get_project_config.js  -name $project -attr config_file`
	
	echo "rm -rf /home/quant_group/${project}/$file"
	rm -rf /home/quant_group/$project/$file
	if [ "$project_type" = "ui" ]
	then
		if $is_public_ip && [ -n "$is_public_ip" ]
		then
			echo "-------link-$project--$config_path/public/$project_type/$project.*----/home/quant_group/$project/$file "
			cp -r $config_path/public/$project_type/${project}.* /home/quant_group/${project}/$file
			if [ $? != 0 ];then
				exit -1
			fi
		else
			echo "-------link-$project--$config_path/$project_type/$project.*----/home/quant_group/$project/$file "
			cp -r $config_path/$project_type/${project}.* /home/quant_group/${project}/$file
			if [ $? != 0 ];then
				exit -1
			fi
		fi
	else
		if $is_public_ip && [ -n "$is_public_ip" ]
		then
			echo "ln -s $config_path/public/$project_type/${project}.* /home/quant_group/${project}/$file"
			ln -s $config_path/public/$project_type/${project}.* /home/quant_group/${project}/$file
			if [ $? != 0 ];then
				echo "link config file fail"
				exit -1
			fi
		else
			echo "ln -s $config_path/$project_type/${project}.* /home/quant_group/${project}/$file"
			ln -s "$config_path/$project_type/${project}.*" /home/quant_group/${project}/$file
			if [ $? != 0 ];then
				echo "link config file fail"
				exit -1
			fi
		fi
		
		if [ "$project" = "xyqb-mall" ]
		then
			rm -rf /home/quant_group/xyqb-mall/baitiao
			echo "~~ln -s $config_path/pem_file /home/quant_group/xyqb-mall/baitiao"
			ln -s $config_path/pem_file /home/quant_group/xyqb-mall/baitiao
		fi
	fi
else
	echo "请输入项目名称project"
fi
