#!/bin/bash
project=$1
config_server=$2
project_path=$3


max_wait_log_generate_time=50
max_wait_ack_time=500
ack_phrase="Started\ Bootstrap"
project=$1
desc=`node $config_server/get_project_config.js  -name $project -attr desc`
run_command_=`node $config_server/get_project_config.js  -name $project -attr command`
run_command=${run_command_//\^/ }
sh $config_server/show_info.sh $project 重新启动 $desc `hostname`
cd $project_path/$project
P_UUID=`ps -ef|grep ${project}.jar |grep -v 'grep'|awk '{print $2}'`
if [ -n "${P_UUID}" ];then
	echo "-----KILL $project PPID=${P_UUID}"
	echo `kill -9 ${P_UUID}`
	sleep 2s
fi

config_file=`find ./ -maxdepth 2 -name "application.properties"`

if [ -n "$config_file" ]
then
	echo "have"
else
	echo "no have"
	if $is_public_ip && [ -n "$is_public_ip" ]
	then
		rm -rf /home/quant_group/${project}/application.properties
		echo "ln -s $config_path/public/java/${project}.* /home/quant_group/${project}/application.properties"
		ln -s $config_path/public/java/${project}.* /home/quant_group/${project}/application.properties
	else
		rm -rf /home/quant_group/${project}/application.properties
		echo "ln -s $config_path/java/${project}.* /home/quant_group/${project}/application.properties"
		ln -s $config_path/java/${project}.* /home/quant_group/${project}/application.properties
	fi
fi

echo "-----project:$project while be start"
log_name=`node $config_server/get_project_config.js  -name $project -attr log_name`

mv $project_path/logs/$log_name $project_path/logs/$project.log.$time

echo "$run_command"

if  [[ $project == "redpacket" ]]; then
	echo `java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${project}.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps  -jar ${project}.jar --worker 1 --currentWorker 1 -t -ts > /dev/null 2>&1 &`
      else
	echo `java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${project}.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps  -jar ${project}.jar --worker 1 --currentWorker 1 -t > /dev/null 2>&1 &`
fi


ack "$ack_phrase" $project_path/logs/$log_name ${max_wait_log_generate_time} ${max_wait_ack_time}
if [ $? -ne 0 ]
then
	echo "Fail to start"
	exit -1
fi