#!/bin/bash
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
filename=ngrok_confg.yml

rm -rf $filename
echo "server_addr: ss.xyqb.loan:4443" >> $filename
echo "trust_host_root_certs: false" >> $filename
echo "tunnels:" >> $filename
function addFile()
{
	echo "$1   : $2  "
 	echo "      $1-iplast:" >> $filename
	echo "        proto:" >> $filename
	echo "           http: \"$2\"" >> $filename
}

projects=(`node $config_server/get_project_config.js  -type java -attr name`)
for project in ${projects[@]}
do
	port=`node $config_server/get_project_config.js  -name $project -attr port`
	addFile $project $port
done

projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
for project in ${projects[@]}
do
	port=`node $config_server/get_project_config.js  -name $project -attr port`
	addFile $project $port
done

projects=(`node $config_server/get_project_config.js  -type node -attr name`)
for project in ${projects[@]}
do
	port=`node $config_server/get_project_config.js  -name $project -attr port`
	addFile $project $port
done

projects=(`node $config_server/get_project_config.js  -type python -attr name`)
for project in ${projects[@]}
do
	port=`node $config_server/get_project_config.js  -name $project -attr port`
	addFile $project $port
done
