#!/bin/bash
project_name=$1
is_public_ip=$2
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
project_type=`node $config_server/get_project_config.js  -name $project_name -attr type`
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

if [ "$project_type" = "java" ]; then
	sh $pwd_path/base_script/restartJava.sh $project_name $config_server $project_path
	# restartJavaProject $project_name $3
elif [ "$project_type" = "node" ]; then
	sh $pwd_path/base_script/restartNode.sh $project_name $config_server $project_path
	# restartNodeProject $project_name $3
elif [ "$project_type" = "python" ]; then
	sh $pwd_path/base_script/restartPython.sh $project_name $config_server $project_path
	# restartPythonProject $project_name $3
elif [ "$project_type" = "ui" ]; then
	sh $pwd_path/base_script/restartUi.sh $project_name $config_server $project_path
	# restartUiProject $project_name $3
fi
