#!/bin/bash
project_type=$1
is_public_ip=$2
ip=$3
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

function restartJavaProject()
{
	projects=(`node $config_server/get_project_config.js  -type java -attr name`)
	echo ${projects[@]}
	for project_name in ${projects[@]}
	do
		echo "$config_server"
		echo "$project_path"
		sh $pwd_path/base_script/restartJava.sh $project_name $config_server $project_path 1
		sleep 10s
	done
}

function restartNodeProject()
{
	pwd_path=$1
	config_server="$pwd_path/config_server"
	project_path="$config_server/project_path.sh"
	
	projects=(`node $config_server/get_project_config.js  -type node -attr name`)
	for project_name in ${projects[@]}
	do
		sh $pwd_path/base_script/restartNode.sh $project_name $config_server $project_path
	done
}

function restartPythonProject()
{
	pwd_path=$1
	config_server="$pwd_path/config_server"
	project_path="$config_server/project_path.sh"
	
	projects=(`node $config_server/get_project_config.js  -type python -attr name`)
	for project_name in ${projects[@]}
	do
		sh $pwd_path/base_script/restartPython.sh $project_name $config_server $project_path
	done
}

function restartUiProject()
{
	nginx -t;  nginx -s reload
}

if [ "$project_type" = "java" ]; then
	restartJavaProject pwd_path
elif [ "$project_type" = "node" ]; then
	restartNodeProject pwd_path
elif [ "$project_type" = "python" ]; then
	restartPythonProject pwd_path
elif [ "$project_type" = "ui" ]; then
	restartUiProject pwd_path
else
	echo "***restart java***"
	restartJavaProject pwd_path
	echo "***restart python***"
	restartPythonProject pwd_path
	echo "***restart node***"
	restartNodeProject pwd_path
	echo "***restart ui***"
	restartUiProject pwd_path
fi
