# -------------------------------------------------------------------------------
# Filename:    db_import.sh
# Revision:    1.1
# Date:        2017/02
# Author:      dekun.dai
# Description: 导入基础数据
# Usage：used by ../deploy/database_sync.sh
# -------------------------------------------------------------------------------

database_name=$1
mysql_host=$2
db_sub_backup_folder=$3
delete_business_data=$4

echo "cd $db_sub_backup_folder"
cd $db_sub_backup_folder
echo "delete_business_data:"$delete_business_data

if [ "$delete_business_data" = "true" ];then
	echo "DROP DATABASE ${database_name};"
	echo "DROP DATABASE ${database_name};" | mysql -h $mysql_host -uqa -pqatest
	echo "CREATE DATABASE IF NOT EXISTS \`${database_name}\` DEFAULT CHARSET utf8 COLLATE utf8_general_ci;"
	echo "CREATE DATABASE IF NOT EXISTS \`${database_name}\` DEFAULT CHARSET utf8 COLLATE utf8_general_ci;" | mysql -h $mysql_host -uqa -pqatest
fi

echo `pwd`

for entry in ./*
do
	echo "mysql -h $mysql_host -u qa -pqatest $database_name < $entry"
	mysql -h $mysql_host -uqa -pqatest $database_name < $entry
	if [ $? != 0 ];then
		echo "import error"
		exit -1
	fi
done
