#!/bin/bash
project_type=$1
pwd_path="/home/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`
node4_path=`cat $config_server/node_4_path.sh`
node7_path=`cat $config_server/node_7_path.sh`
profile=test

function restartJavaProject()
{
	projects=(`node $config_server/get_project_config.js  -type java -attr name`)
	for project in ${projects[@]}
	do
		desc=`node $config_server/get_project_config.js  -name $project -attr desc`
		sh $config_server/show_info.sh $project 关闭 $desc
		cd $project_path/$project
		cd ./target
		P_UUID=`ps -ef|grep ${project}.jar |grep -v 'grep'|awk '{print $2}'`
		if [ -n "${P_UUID}" ];then
			echo "-----KILL $project PPID=${P_UUID}"
			echo `kill -9 ${P_UUID}`
		fi
	done
}

function restartNodeProject()
{
	projects=(`node $config_server/get_project_config.js  -type node -attr name`)
	for project in ${projects[@]}
	do
		desc=`node $config_server/get_project_config.js  -name $project -attr desc`
		sh $config_server/show_info.sh $project 关闭 $desc
		cd $project_path/$project
		forever stop $project
		forever stop $project-www
	done
}

function restartPythonProject()
{
	projects=(`node $config_server/get_project_config.js  -type python -attr name`)
	for project in ${projects[@]}
	do
		desc=`node $config_server/get_project_config.js  -name $project -attr desc`
		sh $config_server/show_info.sh $project 关闭 $desc
		cd $project_path/$project
		setup_path_temp=`find ./ -name "run.py"`
		python_project_path=$project_path/$project${setup_path_temp/\.\//\/}
		
		P_UUID=`ps -ef|grep $project |grep -v 'grep'|awk '{print $2}'`
		if [[ "${P_UUID}" != "" ]];then
			echo "-----KILL $project PPID=${P_UUID}"
			echo `kill -9 ${P_UUID}`
		fi
	done
}

function restartUiProject()
{
	nginx -t;  nginx -s reload
}

if [ "$project_type" = "java" ]; then
	restartJavaProject
elif [ "$project_type" = "node" ]; then
	restartNodeProject
elif [ "$project_type" = "python" ]; then
	restartPythonProject
elif [ "$project_type" = "ui" ]; then
	restartUiProject
else
	restartJavaProject
	restartNodeProject
	restartPythonProject
	restartUiProject
fi
