#!/bin/bash
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"

nginxname="/usr/local/openresty/nginx/conf/conf.d"
pwd_path_0="/home/qa-deploy-utils"

# dockernamespace=`cat $pwd_path/ngrok/docker_env_name.sh`
ips=`cat $config_server/get_env_ip.sh`
rm -rf $filename

rm -rf $nginxname/*


function createNginxHttpAndSSLConf()
{
	project_name=$1
	cus_domain=$2
	cus_ip=$3
	http_port=$4
	https_port=$5
	file_name=$6

	touch $file_name
	echo "############----${project_name}----############" >> $file_name
	echo "server {" >> $file_name
	echo "    listen 80;" >> $file_name
	echo "    server_name  $cus_domain.liangkebang.com;" >> $file_name
	echo "    	underscores_in_headers on;" >> $file_name
	echo "    proxy_set_header  REMOTE_ADDR        \$remote_addr; " >> $file_name
	echo "    proxy_set_header  REMOTE_PORT        \$remote_port; " >> $file_name
	echo "    proxy_set_header Host  \$host;"  >> $file_name
	echo "    proxy_set_header QT_TOKEN  \$http_QT_TOKEN;"  >> $file_name
	echo "    proxy_set_header Upgrade \$http_upgrade;" >> $file_name
	echo "    proxy_set_header Connection \"upgrade\";" >> $file_name
	echo "    client_max_body_size 100M;" >> $file_name
	echo "" >> $file_name
	echo "    location / {" >> $file_name
	echo "        proxy_pass http://$cus_ip:$http_port;" >> $file_name
	echo "    }" >> $file_name
	echo "}" >> $file_name
	echo "" >> $file_name
	echo "server {" >> $file_name
	echo "    listen       443 ssl;" >> $file_name
	echo "    server_name  $cus_domain.liangkebang.com;" >> $file_name
	echo "" >> $file_name
	echo "    proxy_set_header QT_TOKEN  \$http_QT_TOKEN;"  >> $file_name
	echo "    ssl_certificate      /home/q-gp/ssl/liangkebang/certificate.crt;" >> $file_name
	echo "    ssl_certificate_key  /home/q-gp/ssl/liangkebang/private.key;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_session_cache    shared:SSL:1m;" >> $file_name
	echo "    ssl_session_timeout  5m;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_ciphers  HIGH:!aNULL:!MD5;" >> $file_name
	echo "    ssl_prefer_server_ciphers  on;" >> $file_name
	echo "    proxy_set_header  REMOTE_ADDR        \$remote_addr; " >> $file_name
	echo "    proxy_set_header  REMOTE_PORT        \$remote_port; " >> $file_name
	echo "    proxy_set_header Host  \$host;"  >> $file_name
	echo "" >> $file_name
	echo "    location / {" >> $file_name
	echo "        proxy_pass http://$cus_ip:$https_port;" >> $file_name
	echo "    }" >> $file_name
	echo "}" >> $file_name
	
}

_str=""
getK8sConditionStr(){
	_str="${_str}
	if ( \$host ~* .*-${1}.liangkebang.com ) { 
		set \$ip ${2}; 
	}
"
}

createK8sNginxConf(){
	file_name=$1

	echo "server { " >> $file_name
	echo "    listen 80 default; " >> $file_name
	echo "    server_name _; " >> $file_name
	echo "    underscores_in_headers on; " >> $file_name
	echo "    proxy_set_header QT_TOKEN  \$http_QT_TOKEN; " >> $file_name
	
	echo "    proxy_set_header Host  \$host; " >> $file_name
	echo "    proxy_set_header  REMOTE_ADDR        \$remote_addr; " >> $file_name
	echo "    proxy_set_header  REMOTE_PORT        \$remote_port; " >> $file_name
	echo "    client_max_body_size 100M;" >> $file_name
	echo "		 " >> $file_name
	echo "    set \$ip \"192.168.6.12\"; " >> $file_name
	echo "    location / { " >> $file_name
	echo "					${_str} " >> $file_name
	echo "					proxy_pass http://\$ip; " >> $file_name
	echo "    } " >> $file_name
	echo "} " >> $file_name
	echo " " >> $file_name
	echo "server { " >> $file_name
	echo "    listen 443 ssl; " >> $file_name
	echo "		server_name *.liangkebang.com; " >> $file_name
	echo "    proxy_set_header QT_TOKEN  \$http_QT_TOKEN; " >> $file_name
	echo "    ssl_certificate      /home/q-gp/ssl/liangkebang/certificate.crt; " >> $file_name
	echo "    ssl_certificate_key  /home/q-gp/ssl/liangkebang/private.key; " >> $file_name
	echo "    ssl_session_cache    shared:SSL:1m; " >> $file_name
	echo "    ssl_session_timeout  5m; " >> $file_name
	echo "    ssl_ciphers  HIGH:!aNULL:!MD5; " >> $file_name
	echo "    ssl_prefer_server_ciphers  on; " >> $file_name
	echo "    proxy_set_header Host  \$host; " >> $file_name
	echo "    proxy_set_header  REMOTE_ADDR        \$remote_addr; " >> $file_name
	echo "    proxy_set_header  REMOTE_PORT        \$remote_port; " >> $file_name
	echo " " >> $file_name
	echo "		set \$ip \"192.168.6.12\"; " >> $file_name
	echo "    location / { " >> $file_name
	echo "				${_str} " >> $file_name
	echo "        proxy_pass http://\$ip; " >> $file_name
	echo "    } " >> $file_name
	echo "} " >> $file_name

}



# 数据部要求地址
createNginxHttpAndSSLConf auth-center auth-center-38 192.168.4.193 8099 8099 $nginxname/base.conf
createNginxHttpAndSSLConf h5sp h5sp-25 192.168.4.25 7057 7057 $nginxname/base.conf


# 业务要求
createNginxHttpAndSSLConf h5 h5 192.168.6.19 61672 61672 $nginxname/base.conf
createNginxHttpAndSSLConf tyw tyw 192.168.28.170 8081 8081 $nginxname/base.conf
createNginxHttpAndSSLConf qg1 qg1-21 172.30.220.20 8018 8018 $nginxname/base.conf
createNginxHttpAndSSLConf qg1 qg1-21-server 172.30.220.20 9019 9019 $nginxname/base.conf
createNginxHttpAndSSLConf uanguang uanguang 193.168.4.124 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf gongyucheng gongyucheng 192.168.4.254 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf lkb-client lkb-client  172.30.220.7 8082  8082 $nginxname/base.conf
createNginxHttpAndSSLConf operator operator  172.30.220.7 8099  8099 $nginxname/base.conf
createNginxHttpAndSSLConf rule-engine rule-engine  172.30.220.7 9050 9050 $nginxname/base.conf
createNginxHttpAndSSLConf risk-fields risk-fields  172.30.220.13 9010 9010 $nginxname/base.conf
createNginxHttpAndSSLConf es-15920 es-15920 172.30.220.11 15920 15920 $nginxname/base.conf
createNginxHttpAndSSLConf es-16920 es-16920 172.30.220.11 16920 16920 $nginxname/base.conf
createNginxHttpAndSSLConf zk-16181 zk-16181 172.30.220.11 16181 16181 $nginxname/base.conf
createNginxHttpAndSSLConf zk-16182 zk-16182 172.30.220.11 16182 16182 $nginxname/base.conf
createNginxHttpAndSSLConf zk-16183 zk-16183 172.30.220.11 16183 16183 $nginxname/base.conf
createNginxHttpAndSSLConf zk-15181 zk-15181 172.30.220.11 15181 15181 $nginxname/base.conf
createNginxHttpAndSSLConf zk-15182 zk-15182 172.30.220.11 15182 15182 $nginxname/base.conf
createNginxHttpAndSSLConf zk-15183 zk-15183 172.30.220.11 15183 15183 $nginxname/base.conf
createNginxHttpAndSSLConf kafka-16091 kafka-16091 172.30.220.11 16091 16091 $nginxname/base.conf
createNginxHttpAndSSLConf kafka-16092 kafka-16092 172.30.220.11 16092 16092 $nginxname/base.conf
createNginxHttpAndSSLConf kafka-16093 kafka-16093 172.30.220.11 16093 16093 $nginxname/base.conf
createNginxHttpAndSSLConf kafka-15091 kafka-15091 172.30.220.11 15091 15091 $nginxname/base.conf
createNginxHttpAndSSLConf kafka-15092 kafka-15092 172.30.220.11 15092 15092 $nginxname/base.conf
createNginxHttpAndSSLConf kafka-15093 kafka-15093 172.30.220.11 15093 15093 $nginxname/base.conf
createNginxHttpAndSSLConf zipkin-18180 zipkin-18180 172.30.220.11 18180 18180 $nginxname/base.conf
createNginxHttpAndSSLConf zipkin-15180 zipkin-15180 172.30.220.11 15180 15180 $nginxname/base.conf
createNginxHttpAndSSLConf zipkin-16180 zipkin-16180 172.30.220.11 16180 16180 $nginxname/base.conf
createNginxHttpAndSSLConf sync-rabbitmq sync-rabbitmq 172.30.3.140 15672 15672 $nginxname/base.conf
createNginxHttpAndSSLConf lkbclient lkbclient 172.30.220.7 8083 8083 $nginxname/base.conf
createNginxHttpAndSSLConf ldap ldap 172.30.5.214 389 389 $nginxname/base.conf
# 工作目录
createNginxHttpAndSSLConf jen jen 192.168.4.2 8080 8080 $nginxname/base.conf


# 自定义服务
createNginxHttpAndSSLConf qa qa 172.30.220.22  80 80 $nginxname/base.conf
createNginxHttpAndSSLConf qg qg 172.30.220.22 10087 10087 $nginxname/base.conf
createNginxHttpAndSSLConf bp bp 172.30.220.22 10084 10084 $nginxname/base.conf
createNginxHttpAndSSLConf qahelp qahelp 172.30.220.22 8000 8000 $nginxname/base.conf
createNginxHttpAndSSLConf store store 172.30.220.22 9000 9000 $nginxname/base.conf
createNginxHttpAndSSLConf atm atm 172.30.220.43 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf acs acs 172.30.220.43 8585 8585 $nginxname/base.conf
createNginxHttpAndSSLConf a a 172.30.220.22 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf mock mock 172.30.220.22 8080 8080 $nginxname/base.conf
createNginxHttpAndSSLConf mockapi mockapi 172.30.220.22 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf mockm mockm 172.30.220.22 9010 9010 $nginxname/base.conf
createNginxHttpAndSSLConf login login 172.30.220.22 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf user user 172.30.220.22 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf riskfield riskfield 172.30.220.13 9010 9010 $nginxname/base.conf
createNginxHttpAndSSLConf pinjaman-img pinjaman-img 172.30.220.12 22122 22122 $nginxname/base.conf
createNginxHttpAndSSLConf git git 172.30.10.23 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf gitabc gitabc 172.30.10.24 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf sonar sonar 172.30.3.42 9000 9000 $nginxname/base.conf
createNginxHttpAndSSLConf pipes pipes 10.17.115.10 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf kafka kafka 10.17.115.10 80 80 $nginxname/base.conf

for ip_last in ${ips[@]}
do
	IP_host=`sh $pwd_path_0/get-ip.sh $ip_last`
	ip_arr=(${IP_host//./ })
	ipfirst="${ip_arr[0]}.${ip_arr[1]}.${ip_arr[2]}"
	iplast="${ip_arr[3]}"
	ip_last_repeat=${ip_last//./-}
	projectAndPorts=`node $config_server/get_project_config.js  -type multi -attr port -attr2 true`
	for projectAndPort in ${projectAndPorts[@]}
	do
		var=(${projectAndPort//|/ })
		project_name="${var[0]}"
		sub_doman="${var[0]}-${ip_last_repeat}"
		target_ip="$IP_host"
		http_port="${var[1]}"
		https_port="${var[1]}"
		file_name="$nginxname/$target_ip.conf"
		createNginxHttpAndSSLConf $project_name $sub_doman $target_ip $http_port $https_port $file_name
	done
done 

_str=""
# for host_name in ${dockernamespace[@]}
# do
# 	namespace=(${host_name//|/ })
# 	getK8sConditionStr ${namespace[0]}  ${namespace[1]}:${namespace[2]}
# done
createK8sNginxConf $nginxname/k8s.conf

nginx -s reload



#   3     log_format  main  '$remote_addr - $remote_user [$time_local] "$request" '
#   2                       '$status $body_bytes_sent "$http_referer" '
#   1                       '"$http_user_agent" "$http_x_forwarded_for" "$http_QT_TOKEN"';
# 23      server_names_hash_bucket_size 10240;
#   1     sendfile        on;
#   2     tcp_nopush     on;


#  15         access_log  logs/k8s.log main;
 # 16         error_log  logs/k8s_error.log;
 # 17         default_type text/plain;
 
 #       content_by_lua '
 #                       ngx.say(ngx.var.ip);
 #               ';
