#!/bin/bash
ip=$1

mysqld="-h$ip -p3306 -uqa -pqatest"

# 先删除display库的discovery_config表
mysql -N $mysqld display -e "DROP TABLE IF EXISTS discovery_config";

# 再创建display库的discovery_config表
mysql -N $mysqld display -e "CREATE TABLE discovery_config (
  id bigint(11) NOT NULL AUTO_INCREMENT,
  name varchar(50) NOT NULL,
  sort int(4) NOT NULL,
  config_key varchar(50) NOT NULL,
  config_value text NOT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8"

# 给display库的discovery_config表灌入基础数据
mysql -N $mysqld display -e "set names utf-8; insert into discovery_config ( name, sort, config_key, config_value) 
values ( '信用分', '1', 'credit_score', '{\"firstDynamic\":\"信用钱包让有信用的人更有尊严，守护信用，守护尊严！\",\"fixedText\":\"信用分越高，额度越高，费率越低\",\"secondDynamic\":\"我们通过深度学习，汇总得出每位用户的信用分\",\"thirdDynamic\":\"钱包君会综合评估您的额度和动态费率\"}')";

mysql -N $mysqld display -e "set names utf-8; insert into discovery_config ( name, sort, config_key, config_value) 
values ( '授权入口', '2', 'authorize_entrance', '{\"authorizeEntranceModels\":[{\"authorize\":\"运营商认证\",\"enable\":true,\"id\":1,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/FuR2uVd5QLmLJRsJVgZNgwcrHzX2\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/Fi1E87xv63-DaMrng9GJZROJZcgO\",\"name\":\"运营商\",\"sort\":1},{\"authorize\":\"芝麻分\",\"enable\":true,\"id\":4,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/Fri_qH1foasXr_bj1ku2HMzontm5\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/FlGwkdPtIqwx2609gPxS7ft9Aly_\",\"name\":\"芝麻分\",\"sort\":2},{\"authorize\":\"拍照\",\"enable\":true,\"id\":11,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/Fj5vj3j1ErbfpkHgUQCCb9J2HrjN\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/FkvkF6Zkagx1RJoTcHbryC745SCt\",\"name\":\"拍照\",\"sort\":3},{\"authorize\":\"央行征信\",\"enable\":true,\"id\":5,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/FvE0QwGO6ItHI0K97X3vNpG9Q25B\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/FlrpNAxigybGfH2tfmDHs35p8prl\",\"name\":\"央行征信\",\"sort\":4},{\"authorize\":\"京东\",\"enable\":true,\"id\":6,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/Fsqnv3E7VgZn5QZe67ZXGx1Xba7w\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/Fi1Y084ZNGZpIzmEr3P_U5YjYBzy\",\"name\":\"京东\",\"sort\":5},{\"authorize\":\"社保\",\"enable\":true,\"id\":7,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/FsLueJDcYziInejyNTYbA5UNNhxH\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/FvKE3iBvrW-eXb18_OPxi4bMeivT\",\"name\":\"社保\",\"sort\":6},{\"authorize\":\"公积金\",\"enable\":true,\"id\":8,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/Fk-hdu1vNBc4GZY2fqJ_5F3JUedH\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/FuPLTSROy-ItHMY_rAFey1xsTr9l\",\"name\":\"公积金\",\"sort\":7},{\"authorize\":\"信用卡邮箱\",\"enable\":true,\"id\":9,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/Fl4pPhkWzZVztZwgWShFimkNi-VK\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/Fu5hH_p0mUuDoLejLxWGQSydJIC5\",\"name\":\"信用卡邮箱\",\"sort\":8},{\"authorize\":\"学信\",\"enable\":true,\"id\":10,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/FgZPJRaMYD5tdWFaVp5LBhveYNC5\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/FoVq0wwJnoZc9ej7Io-oRl2nciU9\",\"name\":\"学信\",\"sort\":9},{\"authorize\":\"支付宝认证\",\"enable\":false,\"id\":2,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/FlwCceUKFeUaMAt5MmqAjisHeADm\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/Ft-ac0avX9Zel1m-b9JIrc6BA7fn\",\"name\":\"支付宝\",\"sort\":10},{\"authorize\":\"淘宝认证\",\"enable\":false,\"id\":3,\"imgUrl1\":\"https://oic74zs8j.qnssl.com/FknH_6SvvwEJefTQD_SNktEdaXQ7\",\"imgUrl2\":\"https://oic74zs8j.qnssl.com/FooCgQXhVDE5ktMENnlbj3dzah89\",\"name\":\"淘宝\",\"sort\":11}],\"authorizeText\":\"授权信息有助于提升信用分\"}')";

mysql -N $mysqld display -e "set names utf-8; insert into discovery_config ( name, sort, config_key, config_value) 
values ( '贷款大全', '3', 'loan_book', '{\"bannerConfig\":{\"banners\":[{\"enable\":true,\"imgUrl\":\"https://oic74zs8j.qnssl.com/FlFNylgooXgd7wtZS7Ij84wW1a5J\",\"name\":\"贷款大全\",\"navUrl\":\"https://h5.xyqb.com/leadflow/static/home?version=4\"}],\"isShow\":true},\"entranceModels\":[{\"enable\":true,\"imgUrl\":\"https://oic74zs8j.qnssl.com/FgnXRbMz7FypRELrRDsPwLiQWvVV\",\"name\":\"大额专区\",\"navUrl\":\"http://h5.xyqb.com/leadflow/next?nextTitle=%E5%A4%A7%E9%A2%9D%E7%8E%B0%E9%87%91%E8%B4%B7&levelCode=5&version=4\"},{\"enable\":true,\"imgUrl\":\"https://oic74zs8j.qnssl.com/FkObOKD-SE68yvQVDFqmD5cIiZbh\",\"name\":\"小额专区\",\"navUrl\":\"http://h5.xyqb.com/leadflow/next?nextTitle=%E5%B0%8F%E9%A2%9D%E6%9E%81%E9%80%9F%E8%B4%B7&levelCode=6&version=4\"},{\"enable\":true,\"imgUrl\":\"https://oic74zs8j.qnssl.com/FoILJE-_-RdDOn1tvcqZR9Zso9sh\",\"name\":\"新品专区\",\"navUrl\":\"http://h5.xyqb.com/leadflow/next?nextTitle=%E6%96%B0%E5%93%81%E9%80%9F%E9%80%92&levelCode=7&version=4\"},{\"enable\":true,\"imgUrl\":\"https://oic74zs8j.qnssl.com/Fnj7JdABns7BwO9GsjHE-fZRAT5D\",\"name\":\"更多\",\"navUrl\":\"https://h5.xyqb.com/leadflow/static/home?version=4\"}],\"loanStates\":\"7,1,2,3,4,5,6\",\"title\":\"贷款大全\"}')";

mysql -N $mysqld display -e "set names utf-8; insert into discovery_config ( name, sort, config_key, config_value) 
values ( '活动中心', '4', 'activity_center', '{\"bannerConfig\":{\"banners\":[{\"enable\":true,\"imgUrl\":\"https://oic74zs8j.qnssl.com/FvwfjR2jhjYxZI9Z-5Ti5Oiu3n91\",\"name\":\"关注公众号\",\"navUrl\":\"https://activity.xyqb.com/activity/598bfd94195c4f0486d7b3d9\"}],\"isShow\":true},\"entranceModels\":[{\"imgUrl\":\"https://oic74zs8j.qnssl.com/FvwfjR2jhjYxZI9Z-5Ti5Oiu3n91\",\"name\":\"呵呵\",\"navUrl\":\"http://www.baidu.com\",\"sort\":1}],\"imageEntrances\":[{\"imgUrl\":\"https://oic74zs8j.qnssl.com/FrGkkhGyS4ytrFhcihpEChmSauFD\",\"navUrl\":\"https://activity.xyqb.com/activity/59c4b522c0883151901ecde5\"},{\"imgUrl\":\"https://oic74zs8j.qnssl.com/FrscDbUuvBDliVAjztpagXon9J59\",\"navUrl\":\"https://activity.xyqb.com/share-money?userPhone%3D%7Bphone%7D%26token%3D%7Btoken%7D\"}],\"title\":\"活动中心\",\"type\":1}')";

mysql -N $mysqld display -e "set names utf-8; insert into discovery_config ( name, sort, config_key, config_value) 
values ( '扫一扫', '0', 'scan', '{\"isShow\":true}')";


echo "成功创建display库、discovery_config表并灌入基础数据"
