#!/bin/bash
project_type=$1
is_public_ip=$2
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`
java_projects=(`node $config_server/get_project_config.js  -type java -attr name`)
ui_projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
node_projects=(`node $config_server/get_project_config.js  -type node -attr name`)
python_projects=(`node $config_server/get_project_config.js  -type python -attr name`)

function linkProjectConfig()
{
	project=$1
	project_type=$2
	desc=`node $config_server/get_project_config.js  -name $project -attr desc`
	sh $config_server/show_info.sh $project 连接配置文件 $desc
	file=`node $config_server/get_project_config.js  -name ${project} -attr config_file`
	echo "----rm -rf /home/quant_group/${project}/$file"

	rm -rf /home/quant_group/${project}/$file
	
	if $is_public_ip && [ -n "$is_public_ip" ]
	then
		echo "---ln -s $config_path/public/$project_type/${project}.* /home/quant_group/${project}/$file"
		ln -s $config_path/public/$project_type/${project}.* /home/quant_group/${project}/$file
	else
		echo "---ln -s $config_path/$project_type/${project}.* /home/quant_group/${project}/$file"
		ln -s $config_path/$project_type/${project}.* /home/quant_group/${project}/$file
	fi
	
	if [ "$project" = "xyqb-mall" ]
	then
		echo "~~ln -s $config_path/pem_file /home/quant_group/xyqb-mall/baitiao"
		ln -s $config_path/pem_file /home/quant_group/xyqb-mall/baitiao
	fi
}

function cpProjectConfig()
{
	project=$1
	project_type=$2
	desc=`node $config_server/get_project_config.js  -name $project -attr desc`
	sh $config_server/show_info.sh $project 连接配置文件 $desc
	file=`node $config_server/get_project_config.js  -name ${project} -attr config_file`
	echo "----rm -rf /home/quant_group/${project}/$file"
	
	rm -rf /home/quant_group/${project}/$file

	if $is_public_ip && [ -n "$is_public_ip" ]
	then
		echo "---cp $config_path/public/$project_type/${project}.* /home/quant_group/${project}/$file "
		cp $config_path/public/$project_type/${project}.* /home/quant_group/${project}/$file
	else
		echo "---cp $config_path/$project_type/${project}.* /home/quant_group/${project}/$file "
		cp $config_path/$project_type/${project}.* /home/quant_group/${project}/$file
	fi
}

function linkNginxConfdProject()
{
		desc=`node $config_server/get_project_config.js  -name $project -attr desc`
		sh $config_server/show_info.sh nginx_config.d 连接配置文件 $desc
		rm -rf /etc/nginx/conf.d
		ln -s $config_path/nginx_conf.d /etc/nginx/conf.d
		nginx -t;  nginx -s reload
}

if  [ "$project_type" = "java" ]
then
	for project in ${java_projects[@]}
	do
		linkProjectConfig $project java
	done
elif  [ "$project_type" = "ui" ]
then
	for project in ${ui_projects[@]}
	do
		cpProjectConfig $project ui
	done
	linkNginxConfdProject
elif  [ "$project_type" = "python" ]
then
	for project in ${python_projects[@]}
	do
		linkProjectConfig $project python
	done
elif  [ "$project_type" = "node" ]
then
	for project in ${node_projects[@]}
	do
		linkProjectConfig $project node
	done
else
	for project in ${java_projects[@]}
	do
		linkProjectConfig $project java
	done
	for project in ${ui_projects[@]}
	do
		cpProjectConfig $project ui 
	done
	for project in ${node_projects[@]}
	do
		linkProjectConfig $project node
	done
	for project in ${python_projects[@]}
	do
		linkProjectConfig $project python
	done
	linkNginxConfdProject
fi
