#!/bin/bash
project_name=$1
is_public_ip=$2
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
project_type=`node $config_server/get_project_config.js  -name $project_name -attr type`
config_path=`cat $config_server/config_path.sh`
node4_path=`cat $config_server/node_4_path.sh`
node7_path=`cat $config_server/node_7_path.sh`
profile=test


host=`/sbin/ifconfig -a|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d "addr:"`
echo "host=$host"
hosts=(${host//\./ })
suffix=${hosts[3]}


function buildJavaProject()
{
	project=$1
	desc=`node $config_server/get_project_config.js  -name $project -attr desc`
	target_path=`node $config_server/get_project_config.js  -name $project -attr target_path`
	sh $config_server/show_info.sh $project BUILD $desc $2
	cd $project_path/$project
	
	rm -rf $target_path
	rm -rf $project.jar
	
	if [[ "$project" = "xyqb" || "$project" = "gu-bei" || "$project" = "han-gu-guan" || "$project" = "di-ting" || "$project" = "xyqb-offline" || "$project" = "xyqb-user2" ]]; then
		echo "module is $project, need replace sms jar version from 1.0.x to 1.0.2"
		num=`grep -n  -A12 "<id>test</id>"  $project_path/$project/pom.xml| grep "<version>" | awk -F- '{print $1}'`
		echo "----$project-----pom.xml file line: $num------------"
		sed -i  "${num}s/1.0.[0-9]-SNAPSHOT/1.0.6.3-SNAPSHOT/"  $project_path/$project/pom.xml
	fi

	if [[ "$project" = "du-jiang-yan" ]]; then
		num=`grep -n  -A3 "<artifactId>fund-manage-sdk</artifactId>"  $project_path/$project/pom.xml| grep "<version>" | awk -F- '{print $1}'`
		echo "----$project-----pom.xml file line: $num------------"
		sed -i  "${num}s/1.0.[0-9]-SNAPSHOT/1.0.0.${suffix}-SNAPSHOT/"  $project_path/$project/pom.xml
		sed -i  "${num}s/1.0.[0-9].[0-9]/1.0.0.${suffix}-SNAPSHOT/"  $project_path/$project/pom.xml
	fi

  if [[ "$project" = "finance-api" || "$project" = "financial-system" ]]; then
          num=`grep -n  -A1 "<artifactId>quantgroup-sms-sdk</artifactId>"  $project_path/$project/pom.xml| grep "<version>" | awk -F- '{print $1}'`
          echo "----$project-----pom.xml file line: $num------------"
          sed -i  "${num}s/1.0.6.3/1.0.6.3-SNAPSHOT/"  $project_path/$project/pom.xml
  fi

	echo "mvn clean package -P${profile} -Dmaven.test.skip=true"
	mvn clean package -P${profile} -Dmaven.test.skip=true
	echo "$target_path"
	mv $project_path/$project/$target_path/*.jar $project_path/$project/$project.jar
}

function buildUiProject()
{
	project=$1
	desc=`node $config_server/get_project_config.js  -name $project -attr desc`
	sh $config_server/show_info.sh $project BUILD $desc $2
	config_file=`node $config_server/get_project_config.js  -name $project -attr config_file`
	command=`node $config_server/get_project_config.js  -name $project -attr command`
	node_version=`node $config_server/get_project_config.js  -name $project -attr node_version`
	
	# 第一步  将nginx项目的所有文件进行打包
	cd $project_path/$project

#	rm -rf ./$config_file
	
#	if $is_public_ip && [ -n "$is_public_ip" ]
#	then
#		cp -r $config_path/public/ui/$project.* $project_path/$project/$config_file
#	else
#		cp -r $config_path/ui/$project.* $project_path/$project/$config_file
#	fi
	
	#imagemin_dist=`grep -n -A3 "imagemin"  *.js|awk '{print $1}'`
	
	#if [ -n "$imagemin_dist" ];then
	#	echo "npm install gruntjs/grunt-contrib-imagemin"
		#${node4_path}/
	#	npm install gruntjs/grunt-contrib-imagemin
		#${node4_path}/npm --registry http://192.168.3.7:4873 install async
	#else
	#	echo "dont install imagemin"
	#fi
# --registry http://192.168.3.7:4873
	if [ "$node_version" = "node4" ] ;then
		echo "----node-V4---${node4_path}/npm install"
		${node4_path}/npm  install
	else
		npm --registry http://172.16.3.15:4873 install
	fi
	bower_json=`find ./ -maxdepth 1 -name "bower.json"`

	if [ -n "$bower_json" ];then
		echo "bower install --allow-root"
		bower install --allow-root
	else
		echo "don't have bower.json"
	fi

	$command
	# 第二步   不关机使得nginx生效
	nginx -t;  nginx -s reload
}

function buildNodeProject()
{
	project=$1
	desc=`node $config_server/get_project_config.js  -name $project -attr desc`
	sh $config_server/show_info.sh $project BUILD $desc $2
	config_file=`node $config_server/get_project_config.js  -name $project -attr config_file`
	command=`node $config_server/get_project_config.js  -name $project -attr command`
	node_version=`node $config_server/get_project_config.js  -name $project -attr node_version`
	
	# 第一步  将nginx项目的所有文件进行打包
	cd $project_path/$project
	#第二步  关联配置文件
	rm -rf ./$config_file
	echo "  ------------ln -s $config_path/node/$project.*  ./$config_file"
	ln -s $config_path/node/$project.*  ./$config_file
	npmrc=`find ./ -maxdepth 1 -name ".npmrc"`
	echo "---------------$npmrc"
	if [ -n "$npmrc" ];then
		echo "-----1-----"
		npm install
	else
		echo "-----2-----"
		npm --registry http://172.16.3.15:4873 install
	fi
	
}

function buildPythonProject()
{
	project=$1
	desc=`node $config_server/get_project_config.js  -name $project -attr desc`
	sh $config_server/show_info.sh $project BUILD $desc $2
	config_file=`node $config_server/get_project_config.js  -name $project -attr config_file`
	cd $project_path/$project
	setup_path_temp=`find ./ -name "setup.py"`
	python ${setup_path_temp} install
	#第四步  关联配置文件
	rm -rf $config_file
	ln -s $config_path/python/$project.*  $config_file
}

if [ "$project_type" = "java" ]; then
	buildJavaProject $project_name $3
elif [ "$project_type" = "ui" ]; then
	buildUiProject $project_name $3
elif [ "$project_type" = "node" ]; then
	buildNodeProject $project_name $3
elif [ "$project_type" = "python" ]; then
	buildPythonProject $project_name  $3
fi
