# -------------------------------------------------------------------------------
# Filename:    db_replace_ip.sh
# Revision:    1.1
# Date:        2017/02
# Author:      dekun.dai
# Description: 该脚本根据备份sql称特定环境使用的sql
# Usage：used by ../deploy/db_replace_ip.sh
# -------------------------------------------------------------------------------
database_name=$1
server_host=$2
db_sub_backup_folder=$3
re_replace_ip=$4
public_ip="www.q-gp.com"
ip_last=$5
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`


echo $server_host
cd $db_sub_backup_folder

file_count=`ls -l |grep "^-"|wc -l`

hosts=`node $config_server/get_project_config.js -type multi -attr port/url -attr2 true`

function transByPort()
{
	if [ -n "$4" ];then
		echo "sed -i \"s/\/$3.xyqb.com/\/$1-$ip_last.q-gp.com/g\" $4"
		sed -i "s/\/$3.xyqb.com/\/$1-$ip_last.q-gp.com/g" $4
	fi
}

function transByUrl()
{
	if [ -n "$4" ];then
		echo "sed -i \"s/\/$3.xyqb.com/\/${server_host}:$2/g\" $4"
		sed -i "s/\/$3.xyqb.com/\/${server_host}:$2/g" $4
	fi
}

# function transByPara()
# {
# 	if [ -n "$5" ];then
# 		echo "sed -i \"s/\/$3/\/$5-$3/g\" $4"
# 		sed -i "s/\/$3/\/$5-$3/g" $4
# 	fi
# }

if [ $database_name = 'mall' ];then
	config_table='admin_banner album category_banner faster_entrance life_service'
	for entry in $config_table
	do
		sed -i "s/https\:/http\:/g" $entry.sql
		if [ "$re_replace_ip" = true ]; then
			echo "replace public ip for $entry.sql"
			for host in $hosts
			do
				arr=${host//|/ }
				transByPort $arr $entry.sql
			done
		elif [ "$re_replace_ip" = false ];then
			echo "replace ip for $entry.sql"
			for host in $hosts
			do
				arr=${host//|/ }
				transByUrl $arr $entry.sql
			done
		else
			echo "replace $re_replace_ip ip for $entry.sql"
			echo "sed -i "s#.xyqb.com#-${re_replace_ip}.q-gp.com#g" $entry.sql"
			sed -i "s#.xyqb.com#-${re_replace_ip}.q-gp.com#g" $entry.sql
		fi
	done
else
	echo "./* file count is $file_count"
	if [ "$file_count" -gt 0 ]; then
		sed -i "s/https\:/http\:/g" *
		if [ "$re_replace_ip" = true ]; then
			echo "replace public ip for $db_sub_backup_folder/*"
			for host in $hosts
			do
				arr=${host//|/ }
				transByPort $arr $db_sub_backup_folder/*
			done
		elif [ "$re_replace_ip" = false ];then
			echo "replace ip for $db_sub_backup_folder/*"
			for host in $hosts
			do
				arr=${host//|/ }
				transByUrl $arr $db_sub_backup_folder/*
			done
		else
			echo "replace $re_replace_ip ip for $entry"
			echo "sed -i "s#.xyqb.com#-${re_replace_ip}.q-gp.com#g" $entry"
			sed -i "s#.xyqb.com#-${re_replace_ip}.q-gp.com#g" $entry
			#for host in $hosts
			#do
			#	arr=${host//|/ }
			#	transByPara $arr $entry $re_replace_ip
			#done
		fi
	fi
fi

# sed -i "s/\/m.xyqb.com/\/xyqb-ui-$ip_last.q-gp.com/g" $entry
# sed -i  "s/\/bt.xyqb.com/\/${server_host}:7050/g" $entry
# sed -i "s/\/api.xyqb.com/\/${server_host}:7003/g" $entry
# sed -i "s/\/r.xyqb.com/\/${server_host}:7004/g" $entry
# sed -i "s/\/rapi.xyqb.com/\/${server_host}:7005/g" $entry
# sed -i "s/\/payapi.xyqb.com/\/${server_host}:7006/g" $entry
# sed -i "s/\/pay.xyqb.com/\/${server_host}:7007/g" $entry
# sed -i "s/\/off.xyqb.com/\/${server_host}:7008/g" $entry
# sed -i "s/\/offapi.xyqb.com/\/${server_host}:7010/g" $entry
# sed -i "s/\/financial.xyqb.com/\/${server_host}:7011/g" $entry
# sed -i "s/\/fsapi.xyqb.com/\/${server_host}:7012/g" $entry
# sed -i "s/\/auth.xyqb.com/\/${server_host}:7013/g" $entry
# sed -i "s/\/qapi.xyqb.com/\/${server_host}:7014/g" $entry
# sed -i "s/\/mallapi.xyqb.com/\/${server_host}:7019/g" $entry
# sed -i "s/\/scapi.xyqb.com/\/${server_host}:7021/g" $entry
# sed -i "s/\/gyxdapi.xyqb.com/\/${server_host}:7029/g" $entry
# sed -i "s/\/btapi.xyqb.com/\/${server_host}:7025/g" $entry
