-- MySQL dump 10.14  Distrib 5.5.60-MariaDB, for Linux (x86_64)
--
-- Host: 172.17.5.13    Database: workflow
-- ------------------------------------------------------
-- Server version 5.6.43-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `a_b_test`
--

DROP TABLE IF EXISTS `a_b_test`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `a_b_test` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `task_name` varchar(50) NOT NULL COMMENT '任务名称',
  `task_no` varchar(32) NOT NULL COMMENT '任务编号',
  `channel_id` text NOT NULL COMMENT '渠道',
  `rule_id` bigint(11) DEFAULT NULL COMMENT '规则id',
  `dec_flow_weight` text COMMENT '决策流权重',
  `count` int(11) DEFAULT NULL COMMENT '执行总笔数',
  `start_time` timestamp NULL DEFAULT NULL COMMENT '执行开始时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '执行结束时间',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(32) DEFAULT NULL COMMENT '创建用户',
  `updated_by` varchar(32) DEFAULT NULL COMMENT '更改用户',
  `status` tinyint(1) DEFAULT '1' COMMENT '任务状态(1：未开始;2：执行中;3：已终止)',
  `audit_type` tinyint(1) DEFAULT NULL COMMENT '测试节点(0：授信额度审核;1：下单审核;2：预审)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `artificial_audit_log`
--

DROP TABLE IF EXISTS `artificial_audit_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `artificial_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `audit_no` varchar(50) NOT NULL COMMENT '审核单号',
  `uuid` varchar(64) NOT NULL COMMENT 'uuid',
  `biz_channel` varchar(20) NOT NULL COMMENT '渠道号',
  `biz_no` varchar(50) NOT NULL COMMENT '业务订单号',
  `biz_type` tinyint(4) NOT NULL COMMENT '业务类型 0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷,3-KA（如：贝壳）,4-小牛计划,5-预审',
  `audit_method` tinyint(4) NOT NULL COMMENT '业务订单类型,0-授信额度审核,1-下单审核,2-预审',
  `artificial_flow_id` bigint(11) DEFAULT '0' COMMENT '人审模版id',
  `artificial_product_no` varchar(32) DEFAULT NULL COMMENT '人审产品No',
  `audit_result` tinyint(4) DEFAULT NULL COMMENT '0-拒绝,1-通过',
  `audit_context` text COMMENT '审核过程',
  `result_context` text COMMENT '审核结果',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_uuid` (`uuid`) USING BTREE,
  KEY `index_audit_no` (`audit_no`) USING BTREE,
  KEY `index_created_at` (`created_at`) USING BTREE,
  KEY `index_arfificial_flow_id` (`artificial_flow_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人审日志记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `artificial_audit_order`
--

DROP TABLE IF EXISTS `artificial_audit_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `artificial_audit_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `audit_no` varchar(64) NOT NULL COMMENT '审核单号',
  `uuid` varchar(64) NOT NULL COMMENT 'uuid',
  `biz_channel` varchar(20) NOT NULL COMMENT '渠道号',
  `biz_no` varchar(50) NOT NULL COMMENT '业务订单号',
  `biz_type` tinyint(4) NOT NULL COMMENT '业务类型 0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷,3-KA（如：贝壳）,4-小牛计划,5-预审',
  `audit_method` tinyint(4) NOT NULL COMMENT '业务订单类型,0-授信额度审核,1-下单审核,2-预审',
  `audit_status` tinyint(4) NOT NULL COMMENT '订单审核状态 11-待终审(待人工审核),12-待提交终审(终审中),13-终审通过,14-终审拒绝',
  `audit_user` varchar(50) DEFAULT NULL COMMENT '审核人员',
  `user_name` varchar(50) DEFAULT NULL COMMENT '用户姓名',
  `card_no` varchar(25) DEFAULT NULL COMMENT '用户证件号',
  `phone_no` varchar(50) DEFAULT NULL COMMENT '用户手机号',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `human_audit_time` varchar(25) DEFAULT '' COMMENT '人审完成时间',
  `audit_complete_time` varchar(25) DEFAULT '' COMMENT '终审完成时间',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_uuid` (`uuid`) USING BTREE,
  KEY `idx_created_at` (`created_at`) USING BTREE,
  KEY `idx_audit_no` (`audit_no`) USING BTREE,
  KEY `idx_audit_status` (`audit_status`) USING BTREE,
  KEY `idx_audit_user` (`audit_user`) USING BTREE,
  KEY `idx_user_name` (`user_name`) USING BTREE,
  KEY `idx_card_no` (`card_no`) USING BTREE,
  KEY `idx_phone_no` (`phone_no`) USING BTREE,
  KEY `idx_user_status` (`audit_user`,`audit_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人工审核订单表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `audit_fail_log`
--

DROP TABLE IF EXISTS `audit_fail_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audit_fail_log` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `biz_channel` varchar(20) NOT NULL DEFAULT '',
  `biz_no` varchar(50) NOT NULL DEFAULT '',
  `biz_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷',
  `uuid` varchar(50) NOT NULL DEFAULT '',
  `context` text COMMENT '详细信息',
  `fail_reason` text COMMENT '失败原因',
  `enable` tinyint(4) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_uuid` (`uuid`),
  KEY `idx_biz_no` (`biz_no`),
  KEY `index_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='审核失败日志表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `audit_process_log`
--

DROP TABLE IF EXISTS `audit_process_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audit_process_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `flow_id` bigint(11) DEFAULT NULL COMMENT '生效的决策流',
  `loan_id` varchar(32) NOT NULL DEFAULT '',
  `uuid` varchar(50) DEFAULT NULL,
  `product_no` varchar(32) DEFAULT NULL COMMENT '产品ID',
  `content` text COMMENT '详细信息',
  `result` varchar(200) DEFAULT NULL COMMENT '审核结果',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_uuid` (`uuid`) USING BTREE,
  KEY `index_loan_id` (`loan_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='审核过程日志表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `biz_audit_log`
--

DROP TABLE IF EXISTS `biz_audit_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `biz_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `dec_flow_id` bigint(11) DEFAULT NULL COMMENT '决策流ID',
  `biz_no` varchar(50) NOT NULL DEFAULT '',
  `biz_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷',
  `audit_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-授信额度，1-下单',
  `uuid` varchar(50) DEFAULT NULL,
  `product_no` varchar(32) DEFAULT NULL COMMENT '产品编号',
  `audit_result` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-拒绝，1-通过',
  `audit_context` text COMMENT '详细信息',
  `result_context` text COMMENT '审核结果',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_test` tinyint(4) NOT NULL DEFAULT '1' COMMENT '0-平行测试，1-线上',
  `biz_channel` varchar(20) DEFAULT NULL,
  `last_rule` text COMMENT '最后一条执行规则',
  `loan_type` tinyint(4) DEFAULT NULL COMMENT '0-首申，1-复申，2-复贷',
  PRIMARY KEY (`id`),
  KEY `index_uuid` (`uuid`) USING BTREE,
  KEY `index_biz_no` (`biz_no`) USING BTREE,
  KEY `index_dec_flow_id` (`dec_flow_id`) USING BTREE,
  KEY `index_created_at` (`created_at`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='业务审核日志表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `biz_channel`
--

DROP TABLE IF EXISTS `biz_channel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `biz_channel` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `biz_channel` varchar(20) NOT NULL,
  `biz_name` varchar(128) NOT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8 COMMENT='渠道表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `biz_channel_config`
--

DROP TABLE IF EXISTS `biz_channel_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `biz_channel_config` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `biz_channel` varchar(20) NOT NULL,
  `biz_type` tinyint(4) NOT NULL COMMENT '0-循环额度现金贷，1-循环额度白条，2-现金贷，3-白条',
  `method` tinyint(4) NOT NULL COMMENT '0-授信额度，1-下单',
  `product_id` varchar(20) DEFAULT '',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ab_type` varchar(10) DEFAULT 'A' COMMENT 'ABTEST',
  `scene_id` bigint(11) NOT NULL COMMENT 'product_config表对应id',
  PRIMARY KEY (`id`),
  KEY `idx_product_id` (`product_id`),
  KEY `idx_biz_channel_type_method` (`biz_channel`,`biz_type`,`method`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COMMENT='业务渠道配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dec_flow_application`
--

DROP TABLE IF EXISTS `dec_flow_application`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dec_flow_application` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `app_type` tinyint(1) DEFAULT NULL COMMENT '申请类型(0：上线；1：删除)',
  `apply_user_id` int(11) DEFAULT NULL COMMENT '申请人id',
  `app_time` timestamp NULL DEFAULT NULL,
  `check_user_id` int(11) DEFAULT NULL,
  `check_time` timestamp NULL DEFAULT NULL,
  `dec_flow_detail_id` bigint(11) DEFAULT NULL,
  `check_status` tinyint(1) DEFAULT NULL COMMENT '审核结果(0：已拒绝\n\n1：已通过\n\n2：待审批\n\n3: 已撤回)',
  `app_object` tinyint(1) DEFAULT NULL COMMENT '申请对象(0：决策流；1：决策表；2：决策流分支)',
  `refusal_reason` varchar(255) DEFAULT NULL COMMENT '拒绝原因',
  `enable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0：不可用；1：可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `app_desc` varchar(255) DEFAULT NULL COMMENT '申请说明',
  `var_detail_id` bigint(11) DEFAULT NULL COMMENT '特征id',
  PRIMARY KEY (`id`),
  KEY `fk_dec_flow_application_detail` (`dec_flow_detail_id`),
  KEY `fk_dec_user_on_apply_user_id` (`apply_user_id`),
  KEY `fk_dec_user_on_check_user_id` (`check_user_id`),
  CONSTRAINT `fk_dec_flow_application_detail` FOREIGN KEY (`dec_flow_detail_id`) REFERENCES `dec_flow_detail` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_dec_user_on_apply_user_id` FOREIGN KEY (`apply_user_id`) REFERENCES `tb_user` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_dec_user_on_check_user_id` FOREIGN KEY (`check_user_id`) REFERENCES `tb_user` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1668 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dec_flow_detail`
--

DROP TABLE IF EXISTS `dec_flow_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dec_flow_detail` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `dec_flow_no` varchar(32) NOT NULL,
  `dec_flow_name` varchar(20) NOT NULL,
  `dec_flow_desc` varchar(128) DEFAULT NULL,
  `dec_flow_value` text,
  `release_status` tinyint(1) DEFAULT '0' COMMENT '0-未发布，1-发布不执行，2-发布执行',
  `release_confirm` tinyint(1) DEFAULT '0' COMMENT '0-未确认，1-已确认',
  `user_code` varchar(20) NOT NULL DEFAULT '' COMMENT '操作人',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `out_detail` text,
  `is_template` tinyint(1) DEFAULT '0' COMMENT '0不是模板，1-是模板',
  `data_type` tinyint(1) DEFAULT '1' COMMENT '1-决策流，2-决策表',
  `associated` tinyint(1) DEFAULT '0' COMMENT '是否被引用，0-未被引用，1-被引用',
  `is_output` tinyint(1) DEFAULT '0',
  `relevance_ids` text COMMENT '引用到的id数组',
  `application_status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '申请状态(0：待申请；1：审核中；2：已同意；3：已拒绝；4：已撤回)',
  `refusal_reason` varchar(255) DEFAULT NULL COMMENT '审批拒绝原因',
  `is_official` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0：副本；1：正式版',
  `parent_id` bigint(11) DEFAULT NULL COMMENT '副本引用的id',
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_dec_flow_no` (`dec_flow_no`),
  KEY `index_user_code` (`user_code`),
  KEY `fk_dec_flow_detail` (`parent_id`),
  CONSTRAINT `fk_dec_flow_detail` FOREIGN KEY (`parent_id`) REFERENCES `dec_flow_detail` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4246 DEFAULT CHARSET=utf8 COMMENT='决策流详情表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dec_flow_model`
--

DROP TABLE IF EXISTS `dec_flow_model`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dec_flow_model` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `dec_flow_model_no` varchar(32) NOT NULL,
  `dec_flow_name` varchar(20) NOT NULL,
  `dec_flow_desc` varchar(128) DEFAULT NULL,
  `dec_flow_value` text,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `out_detail` text,
  PRIMARY KEY (`id`),
  KEY `index_dec_flow_no` (`dec_flow_model_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='决策流模板';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dec_flow_records`
--

DROP TABLE IF EXISTS `dec_flow_records`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dec_flow_records` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `related_id` bigint(11) NOT NULL COMMENT '关联决策id',
  `associated_id` bigint(11) NOT NULL COMMENT '被关联决策id',
  `dec_flow_no` varchar(30) NOT NULL,
  `dec_flow_name` varchar(20) NOT NULL,
  `dec_flow_desc` varchar(128) DEFAULT NULL,
  `dec_flow_value` mediumtext,
  `relevance_ids` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `out_detail` text,
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '记录数据类型：1 ：批量修改规则',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='决策流、决策流分支修改记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dec_out`
--

DROP TABLE IF EXISTS `dec_out`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dec_out` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `dec_id` bigint(11) DEFAULT NULL,
  `config_code` varchar(32) DEFAULT NULL,
  `expression` tinyint(1) NOT NULL COMMENT '0-不等于，1-等于',
  `out_value` varchar(32) DEFAULT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_dec_id` (`dec_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='决策流输出表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dry_running`
--

DROP TABLE IF EXISTS `dry_running`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dry_running` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `task_name` varchar(50) NOT NULL COMMENT '任务名称',
  `task_no` varchar(32) NOT NULL,
  `channel_id` varchar(20) NOT NULL COMMENT '渠道',
  `dec_flow_ids` text COMMENT '决策流',
  `count` int(11) DEFAULT NULL COMMENT '空跑笔数',
  `start_time` timestamp NULL DEFAULT NULL COMMENT '执行开始时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '执行结束时间',
  `rule_id` bigint(11) DEFAULT NULL COMMENT '规则id',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '任务状态(1：未开始;2：执行中;3：已终止)',
  `execution_node` tinyint(1) DEFAULT NULL COMMENT '执行节点(1：审核通过)',
  `created_by` varchar(32) DEFAULT NULL COMMENT '创建用户',
  `updated_by` varchar(32) DEFAULT NULL COMMENT '更改用户',
  `audit_type` tinyint(1) DEFAULT NULL COMMENT '测试节点(0：授信额度审核;1：下单审核;2：预审)',
  `hit_rule_id` bigint(20) DEFAULT NULL COMMENT '命中规则id',
  `hit_rule_result` varchar(10) DEFAULT NULL COMMENT '命中规则结果, true,false,all',
  `dec_flow_nos` text COMMENT '决策流编号',
  `hit_rules` text COMMENT '命中规则',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `examination`
--

DROP TABLE IF EXISTS `examination`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `examination` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `data` text NOT NULL COMMENT '审批内容',
  `data_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '数据类型 1-决策流',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态 0-未审批，1-已拒绝，2-已审批',
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-未删除，1-已删除',
  `submitter` varchar(50) NOT NULL DEFAULT '' COMMENT '审批提交人',
  `approver` varchar(50) NOT NULL DEFAULT '' COMMENT '审批人',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `business_primary_key` bigint(20) DEFAULT NULL COMMENT '业务主键id，细粒度区分审核条件',
  `business_method` varchar(50) NOT NULL COMMENT '执行业务数据的方法名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='审批记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feature_req_batch`
--

DROP TABLE IF EXISTS `feature_req_batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `feature_req_batch` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `audit_no` varchar(50) NOT NULL COMMENT '审核单号',
  `batch_uuid` varchar(50) NOT NULL COMMENT '特征调用批次号',
  `biz_channel` varchar(20) DEFAULT NULL,
  `biz_no` varchar(50) NOT NULL DEFAULT '',
  `biz_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷',
  `audit_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-授信额度，1-下单',
  `uuid` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_uuid` (`uuid`) USING BTREE,
  KEY `index_audit_no` (`audit_no`) USING BTREE,
  KEY `index_biz_no` (`biz_no`) USING BTREE,
  KEY `index_biz_channel` (`biz_channel`) USING BTREE,
  KEY `index_created_at` (`created_at`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='特征调用批次表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ft_test`
--

DROP TABLE IF EXISTS `ft_test`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ft_test` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `task_no` varchar(32) NOT NULL COMMENT '任务编号',
  `task_name` varchar(50) NOT NULL COMMENT '任务名称',
  `channel_ids` text COMMENT '渠道号',
  `rule_id` bigint(11) DEFAULT NULL,
  `audit_type` tinyint(1) NOT NULL COMMENT '测试节点(0：授信额度审核;1：下单审核;2：预审)',
  `test_unit` text COMMENT '测试单元',
  `stop_time` timestamp NULL DEFAULT NULL COMMENT '终止时间',
  `stop_by` varchar(32) DEFAULT NULL COMMENT '终止操作人',
  `start_time` timestamp NULL DEFAULT NULL COMMENT '开始时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '结束时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '任务状态(1：未开始;2：执行中;3：已终止)',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` varchar(32) DEFAULT NULL COMMENT '创建用户',
  `updated_by` varchar(32) DEFAULT NULL COMMENT '更改用户',
  `unit_num` int(11) DEFAULT NULL COMMENT '单元总数',
  `unit_completed_num` int(11) DEFAULT NULL COMMENT '已完成单元个数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `out_config`
--

DROP TABLE IF EXISTS `out_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `out_config` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `config_code` varchar(32) DEFAULT NULL COMMENT '该字段内容需和业务系统商定，不得擅自修改',
  `config_name` varchar(32) DEFAULT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `data_type` tinyint(4) DEFAULT '1' COMMENT '1-string类型，2-json类型，3-bool类型',
  `configuration_type` tinyint(1) DEFAULT '0' COMMENT '配置类型(0：输出结果;1：待定输出常量)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='输出配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `out_config_value`
--

DROP TABLE IF EXISTS `out_config_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `out_config_value` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `config_id` bigint(20) NOT NULL,
  `out_value` text,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `data_type` tinyint(4) DEFAULT '1' COMMENT '1-string类型,2-json类型',
  `status` tinyint(4) DEFAULT '1' COMMENT '0-不可删，1-可删',
  `hash_code` varchar(16) DEFAULT NULL COMMENT '金融产品集唯一标识',
  `description` varchar(128) DEFAULT NULL COMMENT '名称含义',
  PRIMARY KEY (`id`),
  KEY `index_config_id` (`config_id`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COMMENT='输出配置值表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `params_value`
--

DROP TABLE IF EXISTS `params_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `params_value` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `var_id` bigint(11) NOT NULL,
  `params_type` varchar(10) NOT NULL COMMENT 'e.g. string,int,float',
  `params_title` varchar(20) NOT NULL,
  `params_value` varchar(20) NOT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_var_id` (`var_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='参数值表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `performable_decision_flow`
--

DROP TABLE IF EXISTS `performable_decision_flow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `performable_decision_flow` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `decision_flow_id` bigint(11) NOT NULL COMMENT '变量id',
  `content` text COMMENT '最终执行内容',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_index_decision_flow_id` (`decision_flow_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `performable_rule`
--

DROP TABLE IF EXISTS `performable_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `performable_rule` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `rule_id` bigint(11) NOT NULL COMMENT '变量id',
  `content` text COMMENT '最终执行内容',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_index_rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `product_application`
--

DROP TABLE IF EXISTS `product_application`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_application` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `app_no` varchar(32) NOT NULL COMMENT '申请编号',
  `app_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '申请类型(1：上线)',
  `app_object` tinyint(1) NOT NULL DEFAULT '1' COMMENT '申请对象(1：金融产品集批量修改2: 规则批量修改)',
  `apply_user_id` bigint(11) NOT NULL COMMENT '申请用户id',
  `check_user_id` bigint(11) NOT NULL COMMENT '审批用户id',
  `apply_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '申请时间',
  `check_time` timestamp NULL DEFAULT NULL COMMENT '审批时间',
  `check_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '审批状态(1：待审批\n\n2：已同意\n\n3：已拒绝\n\n4: 已撤回)',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `output_config` text COMMENT '输入输出配置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `product_config`
--

DROP TABLE IF EXISTS `product_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_config` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `product_no` varchar(32) NOT NULL,
  `dec_flow_no` varchar(32) DEFAULT NULL,
  `product_name` varchar(32) NOT NULL,
  `product_desc` varchar(128) DEFAULT NULL,
  `enable` tinyint(1) DEFAULT '0' COMMENT '0-不可用，1-测试,2-上线',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `dec_flow_id` bigint(11) DEFAULT NULL,
  `biz_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-单一审核现金贷，1-循环额度白条，2-循环额度现金贷',
  `method` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-额度审核，1-下单审核',
  PRIMARY KEY (`id`),
  KEY `index_product_no` (`product_no`),
  KEY `index_dec_flow_no` (`dec_flow_no`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='产品配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `product_type_config`
--

DROP TABLE IF EXISTS `product_type_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_type_config` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0：业务线;1：类型',
  `text` varchar(20) DEFAULT NULL,
  `code` int(4) DEFAULT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '是否可用（0：不可用;1：可用）',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relevance_record`
--

DROP TABLE IF EXISTS `relevance_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `relevance_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `related_id` bigint(20) NOT NULL COMMENT '关联id',
  `associated_id` bigint(20) NOT NULL COMMENT '被关联id',
  `data_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '关联类型 1-决策流-规则，决策流-决策表，决策表-决策流',
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除 0-未删除，1-已删除',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `related_key` char(10) NOT NULL COMMENT '关联id名称',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_r_id_a_id_dt` (`related_id`,`associated_id`,`data_type`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8 COMMENT='规则、决策流、决策表等关联关系表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `role_permission_mapping`
--

DROP TABLE IF EXISTS `role_permission_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_permission_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `permission_id` int(11) DEFAULT NULL COMMENT '权限id',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `permission_id` (`permission_id`),
  CONSTRAINT `role_permission_mapping_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `tb_role` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `role_permission_mapping_ibfk_2` FOREIGN KEY (`permission_id`) REFERENCES `tb_permission` (`permission_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=221 DEFAULT CHARSET=utf8 COMMENT='角色、权限关联表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rule_detail`
--

DROP TABLE IF EXISTS `rule_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rule_detail` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `rule_group_no` varchar(32) NOT NULL,
  `rule_no` varchar(32) NOT NULL,
  `rule_name` varchar(32) NOT NULL,
  `rule_desc` varchar(128) DEFAULT NULL,
  `rule_value` text,
  `rule_translate` text,
  `rule_status` tinyint(1) DEFAULT '1' COMMENT '0-关闭，1-开',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_rule_group_no` (`rule_group_no`),
  KEY `index_rule_no` (`rule_no`)
) ENGINE=InnoDB AUTO_INCREMENT=323 DEFAULT CHARSET=utf8 COMMENT='规则详情表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rule_group`
--

DROP TABLE IF EXISTS `rule_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rule_group` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `rule_group_no` varchar(32) NOT NULL,
  `rule_group_name` varchar(32) NOT NULL,
  `rule_group_desc` varchar(128) DEFAULT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_rule_group_no` (`rule_group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COMMENT='规则集表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rule_model`
--

DROP TABLE IF EXISTS `rule_model`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rule_model` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `rule_model_no` varchar(32) NOT NULL,
  `rule_name` varchar(32) NOT NULL,
  `rule_desc` varchar(128) DEFAULT NULL,
  `rule_value` text NOT NULL,
  `rule_translate` text NOT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_rule_model_no` (`rule_model_no`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 COMMENT='规则模板表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rule_monitor_config`
--

DROP TABLE IF EXISTS `rule_monitor_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rule_monitor_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `biz_channel` varchar(20) NOT NULL DEFAULT '' COMMENT '渠道号',
  `biz_channel_name` varchar(30) NOT NULL DEFAULT '' COMMENT '渠道名称',
  `webhook` varchar(251) NOT NULL DEFAULT '' COMMENT '钉钉报警webhook',
  `biz_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷,3-KA,4-小牛计划,5-快审(无订单号)',
  `audit_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '审核类型',
  `enable` tinyint(2) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `enter_monitor` tinyint(2) DEFAULT '0' COMMENT '进件量监控，0-关闭，1-开启',
  PRIMARY KEY (`id`),
  KEY `idx_task` (`biz_channel`,`biz_type`,`audit_type`),
  KEY `index_created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COMMENT='规则拒绝率监控任务配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rule_monitor_data`
--

DROP TABLE IF EXISTS `rule_monitor_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rule_monitor_data` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `biz_channel` varchar(20) NOT NULL COMMENT '渠道号',
  `biz_channel_name` varchar(30) NOT NULL COMMENT '渠道名称',
  `biz_type` tinyint(4) NOT NULL COMMENT '业务类型',
  `audit_type` tinyint(4) NOT NULL COMMENT '审核类型',
  `user_loan_type` tinyint(2) NOT NULL DEFAULT '-1' COMMENT '用户类型,0-首申1-复申-2复贷',
  `count` int(11) NOT NULL DEFAULT '0' COMMENT '进件量',
  `pass_count` int(11) NOT NULL DEFAULT '0' COMMENT '通过数',
  `context` text COMMENT '规则拒绝具体值',
  `enable` tinyint(2) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `monitor_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '监控时间',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_monitor_time` (`monitor_time`),
  KEY `idx_biz_channel` (`biz_channel`),
  KEY `idx_user_loan_type` (`user_loan_type`),
  KEY `index_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='规则拒绝率监控数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rule_threshold_monitor_config`
--

DROP TABLE IF EXISTS `rule_threshold_monitor_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rule_threshold_monitor_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `config_name` varchar(30) NOT NULL DEFAULT '' COMMENT '监控配置名称',
  `biz_channel` varchar(20) NOT NULL DEFAULT '' COMMENT '渠道号',
  `biz_channel_name` varchar(20) NOT NULL DEFAULT '' COMMENT '渠道名称',
  `biz_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷,3-KA,4-小牛计划,5-快审(无订单号)',
  `audit_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '审核类型',
  `user_loan_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '用户类型，-1-所有,0-首申,1-复申,2-复贷',
  `rule_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '规则Id',
  `thresholds` text COMMENT '阈值规则',
  `enable` tinyint(2) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_task` (`biz_channel`,`biz_type`,`audit_type`),
  KEY `idx_rule_id` (`rule_id`),
  KEY `index_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='规则拒绝率监控阈值报警配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `score_card_type`
--

DROP TABLE IF EXISTS `score_card_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `score_card_type` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `sct_name` varchar(32) DEFAULT NULL COMMENT '类别名称',
  `sct_total_score` int(11) NOT NULL DEFAULT '0' COMMENT '类别总评分',
  `enable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `score_card_id` bigint(11) DEFAULT NULL COMMENT '类别所属评分卡id',
  `var_detail_id` bigint(11) DEFAULT NULL COMMENT '类别对应特征id',
  PRIMARY KEY (`id`),
  KEY `fk_sct_var_detail_1` (`score_card_id`),
  KEY `fk_sct_var_detail_2` (`var_detail_id`),
  CONSTRAINT `fk_sct_var_detail_1` FOREIGN KEY (`score_card_id`) REFERENCES `var_detail` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_sct_var_detail_2` FOREIGN KEY (`var_detail_id`) REFERENCES `var_detail` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `score_card_type_detail`
--

DROP TABLE IF EXISTS `score_card_type_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `score_card_type_detail` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `sct_characteristic_type` tinyint(1) DEFAULT NULL COMMENT '特征类型(0：枚举；1：范围；2：其它)',
  `sct_characteristic_rule` varchar(255) DEFAULT NULL COMMENT '特征规则',
  `sct_score` int(11) NOT NULL DEFAULT '0' COMMENT '对应分数',
  `enable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sct_id` bigint(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `detail_sct_ibfk_1` (`sct_id`),
  CONSTRAINT `detail_sct_ibfk_1` FOREIGN KEY (`sct_id`) REFERENCES `score_card_type` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `special_feature`
--

DROP TABLE IF EXISTS `special_feature`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `special_feature` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(128) NOT NULL COMMENT '特征code',
  `name` varchar(128) NOT NULL COMMENT '特征含义',
  `type` tinyint(4) NOT NULL COMMENT '1-付费特征,2必需特征',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_enable` (`enable`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8 COMMENT='特殊特征配置表(收费特征、必需特征)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `statics_log`
--

DROP TABLE IF EXISTS `statics_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `statics_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(30) DEFAULT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `action` varchar(30) DEFAULT NULL,
  `detail` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) DEFAULT '1' COMMENT '1：成功；2：失败',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=604 DEFAULT CHARSET=utf8 COMMENT='审计日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tb_permission`
--

DROP TABLE IF EXISTS `tb_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_permission` (
  `permission_id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_name` varchar(30) DEFAULT NULL COMMENT '权限名',
  `permission_info` text COMMENT '权限描述',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `belongs` varchar(30) DEFAULT NULL COMMENT '上级权限',
  `belongs_Info` text COMMENT '上级权限描述',
  PRIMARY KEY (`permission_id`),
  UNIQUE KEY `role_name` (`permission_name`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8 COMMENT='权限表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tb_role`
--

DROP TABLE IF EXISTS `tb_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_role` (
  `role_id` int(11) NOT NULL AUTO_INCREMENT,
  `role_name` varchar(30) DEFAULT NULL,
  `role_info` text,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`role_id`),
  UNIQUE KEY `role_name` (`role_name`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8 COMMENT='量子魔方系统角色表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tb_user`
--

DROP TABLE IF EXISTS `tb_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(30) DEFAULT NULL,
  `pass_word` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `name` varchar(11) DEFAULT NULL,
  `phone` varchar(11) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `enable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0: 不可用1：可用',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_name` (`user_name`)
) ENGINE=InnoDB AUTO_INCREMENT=158 DEFAULT CHARSET=utf8 COMMENT='量子魔方系统用户表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_amount`
--

DROP TABLE IF EXISTS `user_amount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_amount` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(50) NOT NULL DEFAULT '',
  `product_no` varchar(32) NOT NULL,
  `amount` varchar(20) DEFAULT '',
  `dead_line` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '有效截止时间',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `biz_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷',
  PRIMARY KEY (`id`),
  KEY `idx_uuid` (`uuid`),
  KEY `idx_product_no` (`product_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户额度';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_finance_products`
--

DROP TABLE IF EXISTS `user_finance_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_finance_products` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(50) NOT NULL DEFAULT '',
  `product_no` varchar(32) NOT NULL,
  `finance_products` text,
  `dead_line` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '有效截止时间',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `biz_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-一单一审现金贷，1-循环额度白条 2-循环额度现金贷',
  PRIMARY KEY (`id`),
  KEY `idx_uuid` (`uuid`),
  KEY `idx_product_no` (`product_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户金融产品集';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_role_mapping`
--

DROP TABLE IF EXISTS `user_role_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_role_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `user_role_mapping_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tb_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_role_mapping_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `tb_role` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8 COMMENT='量子魔方系统登录权限表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `var_detail`
--

DROP TABLE IF EXISTS `var_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `var_detail` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `var_type` varchar(10) NOT NULL,
  `var_title` varchar(128) NOT NULL,
  `var_name` varchar(128) NOT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `var_character_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '特征类型(0：基础特征；1：普通衍生特征；2：评分卡衍生特征)',
  `var_remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `var_group_id` bigint(11) DEFAULT NULL COMMENT '特征组id',
  `var_no` varchar(32) DEFAULT NULL COMMENT '评分卡编号',
  `var_rule` text COMMENT '衍生特征规则',
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `related_var_names` text COMMENT '衍生特征规则所关联的名称',
  `is_disable` tinyint(1) DEFAULT '0' COMMENT '是否禁用(0：禁用，1：启用)',
  `application_status` tinyint(1) DEFAULT '0' COMMENT '申请状态(0：已同意;1：待审批;2：已拒绝)',
  PRIMARY KEY (`id`),
  KEY `detail_group_ibfk_1` (`var_group_id`),
  CONSTRAINT `detail_group_ibfk_1` FOREIGN KEY (`var_group_id`) REFERENCES `var_group` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=851 DEFAULT CHARSET=utf8 COMMENT='变量详情表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `var_group`
--

DROP TABLE IF EXISTS `var_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `var_group` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `var_group_name` varchar(32) NOT NULL,
  `var_group_desc` varchar(128) DEFAULT NULL,
  `var_detail_ids` text COMMENT '变量id间用,分隔',
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用, 1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COMMENT='变量组表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `white_list_config`
--

DROP TABLE IF EXISTS `white_list_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `white_list_config` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `biz_no` varchar(50) DEFAULT NULL,
  `audit_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0-授信，1-下单',
  `uuid` varchar(50) NOT NULL DEFAULT '',
  `phone_no` varchar(20) DEFAULT NULL COMMENT '手机号',
  `product_no` varchar(32) DEFAULT NULL COMMENT '产品编号',
  `dead_line` int(8) NOT NULL DEFAULT '0' COMMENT '白名单有效期:天',
  `out_config` text COMMENT '输出信息',
  `enable` tinyint(2) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_uuid` (`uuid`),
  KEY `idx_biz_no` (`biz_no`),
  KEY `idx_phone_no` (`phone_no`),
  KEY `index_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='审核白名配置单表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `white_list_config_new`
--

DROP TABLE IF EXISTS `white_list_config_new`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `white_list_config_new` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(50) NOT NULL DEFAULT '',
  `product_no` varchar(32) DEFAULT NULL COMMENT '产品编号',
  `expir_date` int(11) DEFAULT NULL COMMENT '有效期/天',
  `amount_id` bigint(11) DEFAULT NULL COMMENT '额度id',
  `product_id` bigint(11) DEFAULT NULL COMMENT '金融产品id',
  `dead_line_id` bigint(11) DEFAULT NULL COMMENT '额度有效期id',
  `enable` tinyint(2) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint(4) DEFAULT '1' COMMENT '1:召回白名单，2:多订单白名单',
  `biz_channels` text COMMENT '渠道限制',
  PRIMARY KEY (`id`),
  KEY `idx_uuid` (`uuid`),
  KEY `index_created_at` (`created_at`),
  KEY `index_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='审核白名单配置单表新';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `white_list_config_phone_no`
--

DROP TABLE IF EXISTS `white_list_config_phone_no`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `white_list_config_phone_no` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `phone_no` varchar(15) NOT NULL DEFAULT '',
  `biz_channel` varchar(20) DEFAULT NULL COMMENT '产品编号',
  `expir_date` int(11) DEFAULT NULL COMMENT '有效期/天',
  `amount_id` bigint(11) DEFAULT NULL COMMENT '额度id',
  `product_id` bigint(11) DEFAULT NULL COMMENT '金融产品id',
  `dead_line_id` bigint(11) DEFAULT NULL COMMENT '额度有效期id',
  `enable` tinyint(2) DEFAULT '1' COMMENT '0-无效，1-有效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint(4) DEFAULT '1' COMMENT '1:召回白名单，2:多订单白名单,3:下单审核白名单,4:预审白名单,5:多订单资格检测白名单,6:快速审核白名单',
  PRIMARY KEY (`id`),
  KEY `idx_phone_no` (`phone_no`),
  KEY `index_biz_channel` (`biz_channel`),
  KEY `index_created_at` (`created_at`),
  KEY `index_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='审核手机号白名单配置单';
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-12-24 16:18:41