#!/bin/bash
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
filename=/home/config_files/special/ngrok_confg.yml
vipfilename=/home/config_files/special/ngrok_vip_confg.yml
IP_host_first="192.168.4."
ips=`cat $config_server/get_env_ip.sh`

function addFileHead()
{
	rm -rf $1
	echo "server_addr: ss.xyqb.loan:4443" >> $1
	echo "trust_host_root_certs: false" >> $1
	echo "tunnels:" >> $1
}
addFileHead $filename
addFileHead $vipfilename

function addFile()
{
	echo "$1   : $2  "
 	if [ -n $4 ]
	then
		echo "      $1-$4:" >> $3
	else
		echo "      $1-iplast:" >> $3
	fi
	echo "        proto:" >> $3
	echo "           http: \"$2\"" >> $3
}

#projects=(`node $config_server/get_project_config.js  -type java -attr name`)
#for project in ${projects[@]}
#do
#	port=`node $config_server/get_project_config.js  -name $project -attr port`
#	addFile $project $port $filename
#done

#projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
#for project in ${projects[@]}
#do
#	port=`node $config_server/get_project_config.js  -name $project -attr port`
#	addFile $project $port $filename
#done

#projects=(`node $config_server/get_project_config.js  -type node -attr name`)
#for project in ${projects[@]}
#do
#	port=`node $config_server/get_project_config.js  -name $project -attr port`
#	addFile $project $port $filename
#done

#projects=(`node $config_server/get_project_config.js  -type python -attr name`)
#for project in ${projects[@]}
#do
#	port=`node $config_server/get_project_config.js  -name $project -attr port`
#	addFile $project $port $filename
#done
projects_of_out_proxy=( activity-ui gu-bei activity-op op-api spider-center di-ting merchant-backend cash-loan-flow xyqb xyqb-quartz xyqb-query qgbc-ui bt-ui xyqb-user2 xyqb-ui xyqb-user-ui xyqb-mall )


for ip_last in ${ips[@]}
do
	for project in ${projects_of_out_proxy[@]}
	do
		port=`node $config_server/get_project_config.js  -name $project -attr port`
		addFile $project $IP_host_first$ip_last:$port $vipfilename $ip_last
	done
done 




