var project_name, project_attr, projects = {},
	java_projects = [],
	node_projects = [],
	python_projects = [],
	ui_projects = [];
var param = {
	type: "",
	name: "",
	attr: ""
}
var hosts = {
  "activity-op": "actapi.xyqb.com",
  "activity-op-ui": "activity-op.xyqb.com",
  "activity-ui": "activity.xyqb.com",
  "xyqb": "api.xyqb.com",
  "han-gu-guan": "auth.xyqb.com",
  "xyqb-ui": "m.xyqb.com",
	"xjd-ui": "m.xyqb.com",
  "xyqb-ui--xjd-ui": "m.xyqb.com",
  "bt-ui": "bt.xyqb.com",
  "baitiao": "btapi.xyqb.com",
  "financial-system": "financial-api.xyqb.com",
  "financial-system-ui": "financial.xyqb.com",
  "flow-op-ui": "flow-op.xyqb.com",
  "traffic-webapp": "flow.xyqb.com",
  "funding-corp-op-ui": "funding.xyqb.com",
  "gyxd-ui": "gyxd.xyqb.com",
  "gyxd": "gyxdapi.xyqb.com",
  "ka-spider-center-ui": "h5-auth.quantgroup.cn",
  "h5-ui": "h5.xyqb.com",
  "new-mall-ui": "new-mall.xyqb.com",
	"mall-ui": "mall.xyqb.com",
  "xyqb-mall": "mallapi.xyqb.com",
  "xyqb-h5-backend": "mapi.xyqb.com",
  "merchant-backend": "merchantapi.xyqb.com",
  "merchant-op-ui": "merchant.xyqb.com",
  "new-op-ui": "new-op.xyqb.com",
  "offline-ui": "off.xyqb.com",
  "xyqb-offline": "offapi.xyqb.com",
  "offline-operator-ui": "offop.xyqb.com",
  "op-ui": "op.xyqb.com",
  "di-ting-ui": "r.xyqb.com",
  "di-ting": "rapi.xyqb.com",
  "paycenter-ui": "pay.xyqb.com",
	"new-paycenter-ui":"pay.xyqb.com",
	"paycenter-ui--new-paycenter-ui":"pay.xyqb.com",
  "offline-ui": "off.xyqb.com",
  "xyqb-offline": "offapi.xyqb.com",
  "op-api": "opapi.xyqb.com",
  "order-op-ui": "order.xyqb.com",
  "xyqb-user2": "passportapi.xyqb.com",
  "new-xyqb-user-ui": "passport.xyqb.com",
  "gu-bei": "payapi.xyqb.com",
  "black-hole": "pdf.quantgroup.cn",
  "cash-loan-flow": "qapi.xyqb.com",
  "xyqb-quartz": "quartz.xyqb.com",
  "xyqb-query": "query.xyqb.com",
  "du-jiang-yan": "qunar.xyqb.com",
  "di-ting-ui": "r.xyqb.com",
  "di-ting": "rapi.xyqb.com",
  "jian-men-guan": "rauth.xyqb.com",
  "redpacket": "redpacket.xyqb.com",
  "app-backend": "sappbackend.xyqb.com",
  "spider-center-ui": "sc.xyqb.com",
  "spider-center": "scapi.xyqb.com",
  "score": "scoreapi.xyqb.com",
  "statistics-op-ui": "statistics-op.xyqb.com",
  "statistics-api": "statisticsapi.xyqb.com",
  "baitiao-zhitou": "zt.xyqb.com",
  "silk-road-eureka": "eureka-silkroad.xyqb.com",
  "user_credit": "member.xyqb.com",
  "redis": "redis.xyqb.com",
  "db": "db.xyqb.com",
  "rabbitmq": "rabbitmq.xyqb.com",
  "pinjamancepat": "pinja-api.xyqb.com",
  "pinjamancepat-credit-review-ui":"pinja-cr.xyqb.com",
  "pinjamancepat-credit-review": "pinja-cr-api.xyqb.com",
  "zero-gateway-zuul": "gapi.xyqb.com",
	"xyqb-display": "displayapi.xyqb.com",
	"pinjamancepat-collection-ui":"pinja-collection.xyqb.com",
	"pinjamancepat-collection":"pinja-collection-api.xyqb.com",
	"translate":"translate.xyqb.com",
	"union-ui":"union-ui.xyqb.com",
	"pinjamancepat-config"	:"pinja-config.xyqb.com",
	"clotho":"clotho.xyqb.com",
	"cuishou-ui-new":"urge-ui.quantgroup.cn",
	"urge-dispatcher":"urge.quantgroup.cn",
	"cuishou_external":"cuishouoperation.quantgroup.cn",
	"mall-settlement":"settlementapi.xyqb.com",
	"baitiao-op-backend":"backend.xyqb.com",
	"bospinjaman-ui": "pinjaman.xyqb.com",
	"fund-operate-ui":"clotho-ui.xyqb.com",
	"business-op-ui":"business-op.xyqb.com",
	"new-activity-ui":"new-activity.xyqb-com"
}

var pClass = function() {};
pClass.prototype = {
		init: function(group, isActive, projectType, port, projectName, gitPathHead, logName, configFile, command, nodeVersion, desc, auth, command2, java_target_path) {
			this.project_group = group; //项目所属组  1: 技术部  2: 数据部
			this.name = projectName; //项目名称
			this.type = projectType; //项目类型
			// this.www = www;
			this.url= "";
			this.www= "";
			if(hosts[projectName] != undefined){
				this.url = hosts[projectName].replace(".xyqb.com","").replace(".quantgroup.cn","");//项目线上域名
				this.www = hosts[projectName]
			}
			this.gitPathHead = gitPathHead; //项目git 路径头
			if (group == 1){//技术部地址
				this.git_path = "git@git.quantgroup.cn:" + gitPathHead + "/" + projectName + ".git"  //项目git路径地址
			}else if(group == 2){//数据部地址
				this.git_path = "git@gitabc.xyqb.com:" + gitPathHead + "/" + projectName + ".git"  //项目git路径地址
			}
			
			this.log_name = logName; // 项目日志位置
			this.config_file = configFile; //项目配置文件地址
			this.command = ""; //项目命令1
			this.command_=""; //java项目build过程冲需要的，传参可以不考虑
			this.command2 = command2; //项目命令2
			this.node_version = nodeVersion; //项目的node版本,JAVA 项目里面，这个是启动命令的前缀……
			this.port = port; //项目占用端口
			this.desc = desc; //项目描述
			this.is_active = isActive; //项目是否必要项目
			this.auth = auth; // 项目负责人
			this.target_path = java_target_path; //项目java打包后的jar文件路径
			projects[projectName] = this;
			switch (projectType) {
				case "java":
				this.command = "nohup java " + this.node_version + " -Xmx512m -XX:PermSize64m -Xloggc:/tmp/" + projectName + ".log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -jar " + projectName + ".jar " + command ;
				this.command_ = this.node_version + " -Xmx512m -XX:PermSize64m -Xloggc:/tmp/" + projectName + ".log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps|" + " " + command ;	
				java_projects.push(this);
					if (this.target_path == "") {
						this.target_path = "./target"
					}
					break;
				case "node":
					this.command = command;
					node_projects.push(this);
					break;
				case "ui":
					this.command = command;
					ui_projects.push(this);
					break;
				case "python":
					this.command = command;
					python_projects.push(this);
					break;
			}
		}
	}
// --java
new pClass().init(1,true,"java", "7042", "xyqb-user2", "head_group", "xyqb-user2.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts", "-Denv=dev -Didc=default -Dtech.localhost= -Dtest=true", "用户注册登录-V2-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true,"java", "7003", "xyqb", "QG", "xyqb.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", "-Denv=dev -Didc=default -Dtech.localhost=", "现金贷-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true,"java", "7025", "baitiao", "baitiao", "baitiao.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts", " -Denv=dev -Didc=default -Dtech.localhost= ", "白条-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "baitiao-api/target");
new pClass().init(1,true,"java", "7019", "xyqb-mall", "QG", "mall.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "商城后台-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true, "java", "7010", "xyqb-offline", "QG", "xyqb_offline.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "线下业务-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(2,false,"java", "7005", "di-ting", "QG", "di_ting.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "风控审计-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7013", "han-gu-guan", "QG", "han-gu-guan.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "用户注册登录-V1-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true, "java", "7015", "jian-men-guan", "QG", "jian_men_guan.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "信审服务-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true,"java", "7028", "black-hole", "QG", "black-hole.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "合同中心-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true,"java", "7006", "gu-bei", "funding", "pay-center.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", "-Denv=dev -Didc=default -Dtech.localhost=", "支付中心-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true, "java", "7023", "xyqb-quartz", "QG", "quartz.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "定时任务-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(2,true,"java", "7021", "spider-center", "QG", "spider-center.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "授信-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true,"java", "7037", "cash-loan-flow", "QG", "cash_loan_flow.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", "-Denv=dev -Didc=default -Dtech.localhost=", "现金贷流量对接-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(2,true, "java", "7012", "financial-system", "QG", "financial_system.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "财务系统-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7034", "fund-manage", "QG", "fund_manage.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "债转系统-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true,"java", "7029", "gyxd", "QG", "gyxd.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "广源小贷-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7038", "merchant-backend", "QG", "merchant.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "商户后台-server", "陈东亮", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true,"java", "7031", "redpacket", "baitiao", "redpacket.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", "-Denv=dev -Didc=default -Dtech.localhost=", "红包系统-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(2,false, "java", "7044", "finance-api", "bo.wang", "finance-api.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "财务系统-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(2,false, "java", "7045", "check-accounts", "QG", "check_accounts.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "对账系统-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7014", "du-jiang-yan", "QG", "du_jiang_yan.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "第三方对接导流-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "8051", "msg", "fund_pay", "msg.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " -Denv=dev -Didc=default -Dtech.localhost= ", "新版消息中心", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7052", "xyqb-btzt", "qg-op-backend", "xyqb-btzt.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "白条直投外部", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7053", "xyqb-btzt-internal", "qg-op-backend", "xyqb-btzt-internal.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "白条直投内部", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7060", "baitiao-op-backend", "baitiao", "baitiao-op-backend.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "运营系统服务", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "xyqb-backend/target");
new pClass().init(1,true, "java", "7062", "xyqb-user2-query", "head_group", "xyqb-user2-query.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts  -Dtest=true ", " ", "用户系统查询服务", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(2,false, "java", "7063", "traffic_webapp", "qg-op-backend", "traffic.log","application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "流量分发系统", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7017", "silk-road-eureka", "baitiao", "silk-road-eureka.log", "application.properties", "-Denv=dev --worker 1 --currentWorker 1 -t -ts ", "-DLOG_HOME=/home/quant_group/logs ", "通用注册发现服务", "魏巍", "mvn clean package -U -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7027", "silk-road-caller", "baitiao", "silk-road-caller.log", "application.properties", "-Denv=dev --worker 1 --currentWorker 1 -t -ts ", " -DLOG_HOME=/home/quant_group/logs ", "通用消息调用服务", "魏巍", "mvn clean package -U -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7056", "score", "baitiao", "score.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "积分系统", "刑志超", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7065", "silk-road-backman", "baitiao", "silk-road-backman.log", "application.properties", "-Denv=dev --worker 1 --currentWorker 1 -t -ts ", "-DLOG_HOME=/home/quant_group/logs ", "内部系统适配服务", "魏巍", "mvn clean package -U -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7066", "silk-road", "baitiao", "silk-road.log", "application.properties", "-Denv=dev --worker 1 --currentWorker 1 -t -ts ", "-DLOG_HOME=/home/quant_group/logs", "白条直投-对外系统2", "魏巍", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true, "java", "7059", "baitiao-zhitou", "baitiao", "baitiao-zhitou.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " -Denv=dev -Didc=default -Dtech.localhost= ", "白条直投-对接资金方", "张斌", "mvn clean package -Ptest -Dmaven.test.skip=true", "./xyqb-btzt-internal/target/");
new pClass().init(2,false, "java", "7068", "customer_helpdesk", "data-riskcontrol", "customer_helpdesk.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "外部客服-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7069", "notify", "fund_pay", "notify.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", "-Denv=dev -Didc=default -Dtech.localhost=", "支付中心消息通知系统-server", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7071", "mall-settlement", "baitiao", "mall-settlement.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "商户结算系统", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(2,false, "java", "7072", "data-taurus", "data-riskcontrol", "data-taurus.log", "application.properties", "", " ", "质保金-server", "","mvn clean package -Ptest -Dmaven.test.skip=true","");
new pClass().init(1,false, "java", "7074", "account-center", "QG", "account_center.log", "application.properties", "", " -Denv=dev -Didc=default -Dtech.localhost=", "账户中心-server", "","mvn clean package -Ptest -Dmaven.test.skip=true","");
new pClass().init(1,false, "java", "7079", "user-credit", "QG", "user_credit.log", "application.properties", "", " ", "用户升级-server", "","mvn clean package -Ptest -Dmaven.test.skip=true","");
new pClass().init(2,false, "java", "7076", "urge-dispatcher", "data-riskcontrol", "dispatcher.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "催收系统", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7081", "wechat-config", "fund_pay", "wechat-config.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ", " ", "微信消息推送系统", "",     "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7082", "clotho", "funding", "clotho.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts ","-Denv=dev -Didc=default -Dtech.localhost=", "资金方统计相关功能", "",     "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7085", "mall-canal", "baitiao", "mall_canal.log", "application.properties", "-l 152 -w 2 &", " ", "商城订单监控", "", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false, "java", "7087", "xyqb-display", "baitiao", "display.log", "application.properties", "&", " ", "信用钱包显示配置", "陈东亮", "mvn clean package -Ptest     -Dmaven.test.skip=true", "./display-api/target/");
new pClass().init(1,true, "java", "7087", "user-credit-schedule", "QG", "user_credit_schedule.log", "application.properties", "", " ", "用户升级-server", "","mvn clean package     -Ptest -Dmaven.test.skip=true",    "");
new pClass().init(1,true,"java", "7089", "baitiao-guangda", "baitiao", "baitiao-guangda.log", "application.properties", "--worker 1 --currentWorker 1 -t ", " ", "guangda-server", "宋志超", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false,"java", "7093", "account-center-helper", "QG", "account_center_helper.log", "application.properties", "--worker 1 --curr entWorker 1 -t ", " ", "历史数据处理", "高淑盈", "mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,true, "java", "7096", "card", "baitiao", "card.log", "application.properties", "--worker 1 --currentWorker 1 -t -ts","", "白条量卡", "刘志国","mvn clean package -Ptest -Dmaven.test.skip=true", "");
new pClass().init(1,false,"java", "9001", "pinjamancepat", "QG", "", "application.properties", "--worker 1 --curr entWorker 1 -t ", "", "mimi", "mimi", "", "");
new pClass().init(1,false,"java", "9002", "pinjamancepat-credit-review", "QG", "", "application.properties", "--worker 1 --curr entWorker 1 -t ", "", "mimi", "", "", "");
new pClass().init(1,false,"java", "9003", "zero-gateway-zuul", "DevOps", "", "", "", "", "mimi", "", "", "");
new pClass().init(1,false,"java", "9004", "pinjamancepat-collection", "QG", "", "application.properties", " --worker 1 --curr entWorker 1 -t ", " -Denv=dev -Didc=empty ", "mimi", "", "", "");
new pClass().init(1,false,"java", "7100", "pinjamancepat-config", "QG", "", "application.properties", " --worker 1 --curr entWorker 1 -t ", " -Denv=dev -Didc=empty ", "mimi", "", "", "");

// ui----
new pClass().init(1,true, "ui", "7032", "op-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", "运营系统-ui", "", "", "");
new pClass().init(1,true, "ui", "7040", "activity-ui", "QG", null, "src/app/config.js", "npm run qa", "node7", "活动中心-ui", "", "", "");
new pClass().init(1,true, "ui", "7011", "financial-system-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", "财务系统-ui", "", "", "");
new pClass().init(1,true, "ui", "7030", "gyxd-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", "广源小贷-ui", "", "");
new pClass().init(1,true, "ui", "7008", "offline-ui", "QG", null, "src/app/config/env.config.js", "npm run build", "node7", "线下白条-ui", "", "", "");
new pClass().init(1,true, "ui", "7035", "funding-corp-op-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", "白条债转系统-ui", "", "", "");
new pClass().init(1,true, "ui", "7007", "paycenter-ui", "QG", null, "src/app/config/env.config.js", "npm run qa", "node7", "支付中心-ui", "", "", "");
// new pClass().init(1,false, "ui", "7043", "xyqb-user-ui", "head_group", null, "src/app/config.js", "npm run qa", "node7", "用户注册登录-V2-ui", "", "", "");
new pClass().init(1,true, "ui", "7043", "new-xyqb-user-ui", "ui", null, "src/app/config/env.config.js", "npm run qa", "node7", "新用户注册登录-V2-ui", "", "", "");
new pClass().init(1,true, "ui", "7039", "merchant-op-ui", "QG", null, "src/js/env.config.js", "npm run build", "node7", "商户系统-ui", "", "", "");
new pClass().init(2,true, "ui", "7004", "di-ting-ui", "QG", null, "client/app/config.js", "grunt build", "node7", "信审-ui", "", "", "");
new pClass().init(1,true, "ui", "7020", "spider-center-ui", "QG", null, "src/app/config/env.config.js", "npm run qa", "node7", "授信中心-ui", "", "", "");
new pClass().init(1,true, "ui", "7050", "bt-ui", "QG", null, "src/app/config/env.config.js", "npm --registry http://172.16.3.15:4873 run qa", "node7", "新版白条-ui", "", "", "");
new pClass().init(1,true, "ui", "7058", "mall-ui", "ui", null, "src/app/config/env.config.js", "npm run build", "node7", "商城-ui", "", "", "");
new pClass().init(1,true, "ui", "7001", "xyqb-ui", "QG", null, "client/app/config.js", "grunt build", "node7", "现金贷和白条-现金贷-ui", "", "", "");
new pClass().init(1,true, "ui", "7046", "activity-op-ui", "QG", null, "src/config/env.config.js", "npm run build", "node7", "优惠券管理后台-ui", "", "", "");
new pClass().init(1,true, "ui", "7048", "order-op-ui", "OP", null, "src/js/env.config.js", "gulp build", "node7", "订单系统-ui", "", "", "");
// new pClass().init(false, "ui", "7002", "", "qgbc-ui", false, "QG", null, "src/app/config/env.config.js", "npm run build_production", "node7", "白条-ui", "", "", "");
new pClass().init(1,true, "ui", "7057", "xjd-ui", "QG", null, "src/app/config/env.config.js", "npm run qa", "node7", "新版现金贷-ui", "", "", "");
new pClass().init(1,true, "ui", "7007", "new-paycenter-ui", "QG", null, "src/app/config/env.config.js", "npm run qa", "node7", "新版支付中心-ui", "", "", "");
new pClass().init(1,false, "ui", "7061", "wind-control-op-ui", "ui", null, "src/app/config/env.config.js", "npm run qa", "node7", "临时项目，未来删除风控平台-ui", "", "", "");
new pClass().init(1,false, "ui", "7016", "flow-op-ui", "ui", null, "src/config/env.config.js", "npm run build", "node7", "导流UI页面", "", "", "");
new pClass().init(1,false, "ui", "7051", "h5-ui", "ui", null, "src/app/config/env.config.js", "npm run qa", "node7", "h5平台业务", "李长城", "", "");
new pClass().init(1,true, "ui", "7057", "ka-spider-center-ui", "ui", null, "src/app/config/env.config.js", "npm run qa", "node7", "新版授信UI", "郑少文", "", "");
new pClass().init(1,true, "ui", "7067", "new-op-ui", "ui", null, "src/config/env.config.js", "npm run build", "node7", "运营系统 vue", "孙小英", "", "");
new pClass().init(1,true, "ui", "7070", "customer-op-ui", "ui", null, "src/config/env.config.js", "npm run build", "node7", "外部查询-ui", "", "", "");
new pClass().init(1,true, "ui", "7075", "business-op-ui", "ui", null, "src/config/env.config.js", "npm run build", "node7", "商城结算系统-ui", "王丽英", "", "");
new pClass().init(2,true, "ui", "7077", "cuishou-ui-new", "data", null, "src/Config/config.jsx", "npm --registry https://registry.npm.taobao.org run dist", "node7", "催收系统-ui", "李斌", "", "");
new pClass().init(1,true, "ui", "7078", "ka-factory-ui", "ui", null, "src/config/env.config.js", "npm run build", "node7", "KA工厂-ui", "张振武", "", "");
new pClass().init(1,false, "ui", "7064", "statistics-op-ui", "ui", null, "src/app/config/env.config.js", "npm run qa", "node7", "流量统计平台-ui", "刘威", "", "");
new pClass().init(1,true, "ui", "7084", "gdxd-op-ui", "ui", null, "src/config/env.config.js", "npm run qa", "node7", "广达小贷后台-ui", "薛志杰", "", "");
new pClass().init(1,true, "ui", "7080", "new-mall-ui", "ui", null, "src/app/config/env.config.js", "npm run qa", "node7", "微信商城-ui", "郑少文，周珊", "", "");
new pClass().init(2,true, "ui", "7094", "cuishou_external", "data", null, "app/config/production.config.js", "npm --registry https://registry.npm.taobao.org  run build", "node7", "催收对外平台-ui", "李斌", "", "");
new pClass().init(1,true, "ui", "7095", "fund-operate-ui", "ui", null, "src/config/env.config.js", "npm run qa", "node7", "资金运营系统-ui", "徐胜男", "", "");
new pClass().init(1,false, "ui", "9050", "pinjamancepat-credit-review-ui", "ui", null, "src/config/env.config.js", "npm run qa", "", "mimi", "", "", "");
new pClass().init(1,false, "ui", "9051", "pinjamancepat-collection-ui", "ui", null, "src/config/env.config.js", "npm run qa", "", "mimi", "", "", "");
new pClass().init(1,true, "ui", "7097", "new-activity-ui", "ui", null, "src/app/config/env.config.js", "npm run qa", "node7", "新版活动中心-ui", "张振武", "", "");
new pClass().init(1,true, "ui", "7099", "union-ui", "data", null, "src/config/env.config.js", "npm run qa", "node7", "信用联盟UI页面", "安缓缓", "", "");
new pClass().init(1,true, "ui", "7098", "user-manage-ui", "ui", null, "src/config/env.config.js", "npm run qa", "node7", "用户管理系统ui", "李丽华", "", "");
new pClass().init(1,true, "ui", "7101", "bospinjaman-ui", "ui", null, "./empty.js", "npm run qa", "node7", "官网", "孙小樱", "", "");


// node
new pClass().init(1,true, "node", "7018", "app-backend", "QG", null, "config/environment/test.js", "forever start -a -s --uid AppBackend bin/www", null, "APP后台服务-server", "", "forever stop AppBackend", "");
new pClass().init(1,true, "node", "7041", "activity-op", "QG", null, "src/dev.config.js", "sh start.sh", null, "优惠券中心-server", "", "sh stop.sh", "");
new pClass().init(1,true, "node", "7047", "op-api", "OP", null, "src/dev.config.js", "sh start.sh", null, "系统Api-Gateway-server", "", "sh stop.sh", "");
new pClass().init(1,true, "node", "7049", "fe-api", "QG", null, "src/config.js", "sh start.sh", null, "科传项目-消息推送", "", "pm2 stop fe-api", "");
new pClass().init(1,true, "node", "7054", "xyqb-h5-backend", "QG", null, "src/dev.config.js", "sh start.sh", null, "信用钱包帮助中心", "", "sh stop.sh", "");
new pClass().init(1,true, "node", "7055", "statistics", "OP", null, "src/config.js", "sh start.sh", null, "收集前端日志", "", "sh stop.sh", "");
new pClass().init(1,true, "node", "7086", "message-center-op", "ui", null, "config/env/test.js", "sh start.sh", null, "处理营销时消息处理与发送", "", "sh stop.sh", "");
new pClass().init(1,true, "node", "7073", "statistics-api", "ui", null, "src/dev.config.js", "sh start.sh", null, "数据可视化-server", "","sh stop.sh","");
new pClass().init(1,true, "node", "8073", "translate", "ui", null, "src/config/develop.config.js", "node app.js", null, "", "","","");


//python
new pClass().init(1,false, "python", "7022", "qin-qiong", "QG", null, "config/beta/config.properties", null, null, "加密解密-server", "", "", "");
new pClass().init(1,true, "python", "7033", "xyqb-query", "QG", null, "server/config/beta/config.ini", null, null, "query-server", "", "", "");
// new pClass().init(false, "python", "7027", "msg-center", false, "QG", null, "server/config/beta/config.ini", null, null, "短信中心-以前的sms-center", "", "", "");

var temp = "";

process.argv.forEach(function(val, index, array) {
	if (index >= 2) {
		if (index % 2 == 0) {
			temp = val.replace(/\-/, "");
			param[temp] = "";
		} else {
			param[temp] = val;
		}
	}
});

function getListAttr(projects, attr) {
	var list = [];
	for (var i = 0; i < projects.length; i++) {
		// if (projects[i].is_active) {
			list.push(projects[i][attr])
		// }
	}
	return list.join(" ");
}
var configFunction = function() {};
configFunction.prototype = {
	getProjectAttr: function(pName, pAttr) {
		if (typeof projects[pName] == "undefined") {
			console.log("")
		} else {
				var attrs = pAttr.split("/");
				if (attrs.length == 0) {
					console.log("")
					return
				}
				var list = [];
				for (var j = 0; j < attrs.length; j++) {
					if(projects[pName][attrs[j]]){
						
						list.push(projects[pName][attrs[j]].split(" ").join("^"));
					}else{
						list.push(" ");
					}
				}
				console.log(list.join("|"))
		}
	},
	getProjectsAttrs: function(projects, attr, attr2) {
		var attrs = attr.split("/");
		if (attrs.length == 0) {
			return
		}
		var list = [];
		//attr2 专有参数，用来表示是否要取带有对外域名的服务
		if(attr2 == "true"){
			for (var i = 0; i < projects.length; i++) {
				if(projects[i].url != ""){
					var li = [projects[i]["name"]];
					for (var j = 0; j < attrs.length; j++) {
						li.push(projects[i][attrs[j]]);
					}
					// li.push(projects[i].url);
					list.push(li.join("|"));
				}
			}
		}else{
			for (var i = 0; i < projects.length; i++) {
				// if (projects[i].is_active){
					var li = [projects[i]["name"]];
					for (var j = 0; j < attrs.length; j++) {
						li.push(projects[i][attrs[j]]);
					}
					list.push(li.join("|"));
				// }
			}
		}
		return list.join(" ");
	},
	getProjectsAttr: function(type, attr) {
		switch (type) {
			case "java":
				console.log(getListAttr(java_projects, attr));
				break;
			case "ui":
				console.log(getListAttr(ui_projects, attr));
				break;
			case "python":
				console.log(getListAttr(python_projects, attr));
				break;
			case "node":
				console.log(getListAttr(node_projects, attr));
				break;
		}
	}
}

//tower add
module.exports={
	java : java_projects,
	node : node_projects,
	python : python_projects,
	ui : ui_projects
}

var F = new configFunction();

if (param["type"] == "") {
	F.getProjectAttr(param["name"], param["attr"]);
} else if (param["type"] == "multi") {
	var str = "";
	str += F.getProjectsAttrs(java_projects, param["attr"], param["attr2"]);
	str += " " + F.getProjectsAttrs(ui_projects, param["attr"], param["attr2"]);
	str += " " + F.getProjectsAttrs(python_projects, param["attr"], param["attr2"]);
	str += " " + F.getProjectsAttrs(node_projects, param["attr"], param["attr2"]);
	console.log(str)
} else if (param["type"] == "hosts") {
	console.log(JSON.stringify(hosts));
} else {
	F.getProjectsAttr(param["type"], param["attr"]);
}
