#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    db_schema_sync.sh
# Revision:    1.0
# Date:        2016/12
# Author:      dekun.dai
# Description: 实现数据库表结构同步
# -------------------------------------------------------------------------------

source ~/.bash_profile
source ~/.profile

if [ $# -ne 10 ]; then
	echo "---------------"
	echo "source_db_infos：source_db_host: $1, source_db_user: $2"
	echo "target_db_infos：target_db_host: $4, target_db_user: $5"
	echo "sync_db_name: $7, re_replace_ip: $8"
	echo "delete_business_data: $9"
	echo "use_cache: ${10}"
	echo "--- 参数不正确 ---"
	echo "Usage:sh db_schema_sync.sh source_db_host source_db_user source_db_pwd target_db_host target_db_user target_db_pwd sync_db_name"
	echo "---------------"
	exit 1
fi

source_db_host=$1
source_db_user=$2
source_db_pwd='Uiwb@o^fR&nHOa5t'

ip_value=$4

target_db_user=$5
target_db_pwd=$6

sync_db_name=$7
re_replace_ip=$8
delete_business_data=$9
use_cache=${10}

work_dir=/home/qa-deploy-utils/db-utils
sync_config_folder=~/db_sync_configs
db_backup_folder=~/db_backups

trap "exec 1000>&-;exec 1000<&-;exit 0" 2
tempfifo=$$.fifo
echo "mkfifo /tmp/$tempfifo"
mkfifo /tmp/$tempfifo
exec 1000<>/tmp/$tempfifo
rm -rf /tmp/$tempfifo

for ((i=1; i<=2; i++))
do
	echo >&1000
done

function valid_ip()
{
    local  ip=$1
    local  stat=1

    if [[ $ip =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$ ]]; then
        OIFS=$IFS
        IFS='.'
        ip=($ip)
        IFS=$OIFS
        [[ ${ip[0]} -le 255 && ${ip[1]} -le 255 \
            && ${ip[2]} -le 255 && ${ip[3]} -le 255 ]]
        stat=$?
    fi
    return $stat
}

if valid_ip $ip_value; then target_db_host="$ip_value"; else target_db_host="192.168.4.$ip_value"; fi

function db_schema_sync()
{	
	database=$1
	uuid=$(uuidgen)
	config_file_name="$sync_config_folder/${database}_${uuid}_db_schema_sync_config.json"
	db_backup_sub_folders=$db_backup_folder/${uuid}
	
	echo "mkdir $db_backup_sub_folders"
	mkdir $db_backup_sub_folders
	
	echo "--- Step 1: generate_config_file: $config_file_name ---"
	echo "source infos: $source_db_host $source_db_user"
	echo "target infos: $target_db_host $target_db_user"
	echo "database_name is : $sync_db_name"
	echo "delete_business_data : $delete_business_data"
	echo "use_cache : $use_cache"

	sh $work_dir/db_gen_config.sh $source_db_host $source_db_user $source_db_pwd $target_db_host $target_db_user $target_db_pwd $database $config_file_name $db_backup_sub_folders $use_cache
	
	echo "--- Step 2: replace domain name in tables: $database $mysql_host $db_backup_sub_folders ---"
	echo "--- Step 2: is re_replace_ip: $re_replace_ip ---"
	sh $work_dir/db_replace_ip.sh $database $target_db_host $db_backup_sub_folders $re_replace_ip $ip_value

	echo "--- Step 3: import basic data from backup file: $database $mysql_host $db_backup_sub_folders ---"
	sh $work_dir/db_import.sh $database $target_db_host $db_backup_sub_folders $delete_business_data
	#if [ $? != 0 ];then
	#	echo "db_import.sh error"
	#	exit -1
	#fi
	
	echo "--- Step 4: sync schema: $database $target_db_host ---"
	sync_cmd="mss -conf ${config_file_name} -sync"
	echo "${sync_cmd}"
	$sync_cmd
	
	rm -rf $db_sub_backup_folder
}

function run_sql_file()
{
        sync_db_name=$1
        echo "run sql files on ${target_db_host}'s $sync_db_name"
        sh $work_dir/db_execute_sql.sh $target_db_host $sync_db_name
}

database_list='mall cash_loan_flow contract dujiangyan financial_system financial_system_api fund_manage gyxd merchant notify offline payment_center qinqiong quartz redpacket risk_control silk_road spider_center user_credit xyqb xyqb_app xyqb_btzt xyqb_user'

if [[ "$sync_db_name" = "all" ]]
then
	echo "sync all database schema"
elif [[ "$sync_db_name" = "all(no_mall)" ]];then
	database_list=`echo $database_list | sed 's#mall ##g'`
	echo "sync all(no_mall) database schema"
else
	database_list=$sync_db_name
	echo "sync $sync_db_name database schema"
fi

echo "database_list:${database_list}"
for db_name in $database_list
do
	read -u1000
	{
		echo "----------------------------------------------------"
		echo "--- start sync $db_name ---"
		db_schema_sync $db_name
		run_sql_file $db_name
		echo "--- end sync $db_name ---"
		echo >&1000
	}&
done
wait
echo "----------------------------------------------------"

