#!/bin/bash
project=$1
config_server=$2
project_path=$3
ip=$4
profile=test
time=`date +%Y_%m_%d_%H_%M_%S`

function ack()
{
    ack_phrase="$1"
    log_path="$2"
    max_wait_log_generate_time="$3"
    max_wait_ack_time="$4"
    wait_log_generate_time=0
    wait_ack_time=0
    echo "begin acknowledge whether the deploy start OK, ACK_PHRASE=${ack_phrase}, log_path=${log_path}"
    while [ ! -f ${log_path} ]
    do
        echo "waiting for $ip $project log:${log_path}, wait_log_generate_time is ${wait_log_generate_time}, max_wait_log_generate_time is ${max_wait_log_generate_time} "
        if ((${wait_log_generate_time}>${max_wait_log_generate_time}))
        then
            echo "the $ip $project log generated time exceed the limit"
            exit -1
        fi
        echo "the $ip $project log does not exist, wait for 5 seconds"
        sleep 5
        let "wait_log_generate_time+=5"
    done
    echo "listen for the $ip $project log ack..."
    for ((i=0;;))
    do
        #首先查询是否有启动失败的报错日志
        fail_flag=`grep -E "APPLICATION FAILED TO START|Application startup failed" ${log_path} | wc -l`
        if [ "${fail_flag}" = 1 ];then
            echo "server $ip $project startup failed in ${wait_ack_time} seconds..."
            num=`grep -n -E "APPLICATION FAILED TO START|Application startup failed" $log_path | cut -d ":" -f 1`
            if [ -n "$num" ];then
                echo "server $ip $project 启动日志错误信息截取如下："
                sed -n "$[$num],$[$num+10]p" $log_path
            fi
            exit -1
        fi

        bootstrap_flag=`cat ${log_path} |grep "${ack_phrase}"| wc -l`
        if [ "${bootstrap_flag}" = 0 ] && [ "${max_wait_ack_time}" -gt "${wait_ack_time}" ]
        then
            sleep 5
            let "wait_ack_time+=5"
            echo "waiting for $ip $project started flag for ${wait_ack_time} seconds"
        elif [ "${bootstrap_flag}" = 1 ]
        then
            echo "server $ip $project started ok in $wait_ack_time seconds~"
            exit 0
        else
            echo "server $ip $project not startup in ${max_wait_ack_time} seconds..."
            #echo "num=`grep -n \"\[ERROR\]\" $log_path | head -1 |cut -d ":" -f 1`"
            num=`grep -n -E "APPLICATION FAILED TO START|Application startup failed" $log_path | cut -d ":" -f 1`
            if [ -n "$num" ];then
                echo "server $ip $project 启动日志错误信息截取如下："
                sed -n "$[$num],$[$num+10]p" $log_path
            fi
            exit -1
        fi
    done
}

max_wait_log_generate_time=10
max_wait_ack_time=500
ack_phrase="JVM\ running\ for"
project=$1
desc=`node $config_server/get_project_config.js  -name $project -attr desc`
run_command_=`node $config_server/get_project_config.js  -name $project -attr command_`
run_commands=(${run_command_//|/ })
sh $config_server/show_info.sh $project 重新启动 $desc $ip 
cd $project_path/$project
P_UUID=`ps -ef|grep ${project}.jar |grep -v 'grep'|awk '{print $2}'`
if [ -n "${P_UUID}" ];then
    echo "Kill $project PPID=${P_UUID}"
    kill -9 ${P_UUID}
    sleep 2s
fi

config_file=`find ./ -maxdepth 2 -name "application.properties"`

if [ -n "$config_file" ]
then
    echo "$project already have config file"
else
    echo "$project have no config file"
    if $is_public_ip && [ -n "$is_public_ip" ]
    then
        rm -rf /home/quant_group/${project}/application.properties
        echo "ln -s $config_path/public/java/${project}.* /home/quant_group/${project}/application.properties"
        ln -s $config_path/public/java/${project}.* /home/quant_group/${project}/application.properties
    else
        rm -rf /home/quant_group/${project}/application.properties
        echo "ln -s $config_path/java/${project}.* /home/quant_group/${project}/application.properties"
        ln -s $config_path/java/${project}.* /home/quant_group/${project}/application.properties
    fi
fi

echo "Project: $project will be start"
log_name=`node $config_server/get_project_config.js  -name $project -attr log_name`

mv $project_path/logs/$log_name $project_path/logs/$log_name.$time

command1=${run_commands[0]//\^/ }
command2=${run_commands[1]//\^/ }
echo "java $command1 -jar ${project}.jar $command2"
java $command1 -jar ${project}.jar $command2 > /dev/null 2>&1 &
echo "日志名称：$log_name"

#if  [[ $project == "redpacket" ]]; then
#    java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${project}.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps  -jar ${project}.jar --worker 1 --currentWorker 1 -t -ts > /dev/null 2>&1 &
#else
#    java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${project}.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps  -jar ${project}.jar --worker 1 --currentWorker 1 -t > /dev/null 2>&1 &
#fi

if [[ $check_ack == "1" ]]; then
    ack "$ack_phrase" $project_path/logs/$log_name ${max_wait_log_generate_time} 700
    if [ $? -ne 0 ]
    then
        echo "Fail to start"
        exit -1
    fi
else
    ack "$ack_phrase" $project_path/logs/$log_name ${max_wait_log_generate_time} ${max_wait_ack_time}
    if [ $? -ne 0 ]
    then
        echo "Fail to start"
        exit -1
    fi
fi

