#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    multiple_deploy.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本调用其他脚本实现java项目的自动化部署。deploy_xyqb，deploy_di-ting等jenkins job使用了该脚本。
# -------------------------------------------------------------------------------

source ~/.bash_profile
module_type=$1
target_host=$2
use_public_ip=$3
utils_path=/home/quant_group/test-utils

java_module_list='black-hole di-ting du-jiang-yan financial-system gyxd han-gu-guan jian-men-guan mall pay-center quartz spider-center xyqb xyqb-offline'
if [[ "${module_type}" = "java" ]]
then
    echo "deploy all java modules"
    for module in $java_module_list
    do
        if [[ "${module}" = "mall" ]]; then
            project_name='xyqb-mall'
        elif [[ "${module}" = "pay-center" ]]; then
            project_name='gu-bei'
        else
            project_name=${module}
        fi

        git clone http://gitabc.xyqb.com/QG/${project_name}.git
        cd $project_name
        # xyqb $branch_name $target_host $re_checkout $re_build $re_scp $re_start $re_load_config
        sh ${utils_path}/sh-utils/deploy/java_deploy.sh $module master $target_host true true true true true "${use_public_ip}"
    done
elif [[ "${module_type}" = "ui" ]]; then
    echo "deploy all ui modules"
    for module in $ui_module_list
    do
        # xyqb $branch_name $target_host $re_checkout $re_build $re_scp $re_start $re_load_config
        sh ${utils_path}/sh-utils/deploy/ui_deploy.sh $module master $target_host true true true true true
    done
elif [[ "${module_type}" = "python" ]]; then
    echo "deploy all python modules"
    for module in $python_module_list
    do
        # xyqb $branch_name $target_host $re_checkout $re_build $re_scp $re_start $re_load_config
        sh ${utils_path}/sh-utils/deploy/other_deploy.sh $module master $target_host true true true true true
    done
elif [[ "${module_type}" = "js" ]]; then
    echo "deploy all js modules"
    for module in $python_module_list
    do
        # xyqb $branch_name $target_host $re_checkout $re_build $re_scp $re_start $re_load_config
        sh ${utils_path}/sh-utils/deploy/other_deploy.sh $module master $target_host true true true true true
    done
fi


