#!/bin/sh
source ~/.bash_profile
module_name=$1
worker_host=$2
re_load_config=$3
use_public_ip=$4
public_ip="139.198.2.95"

echo "java_start parameter: module_name: ${module_name}, worker_host: ${worker_host}, re_load_config: ${re_load_config}, use_public_ip: ${use_public_ip}"

echo "cd /home/quant_group/${module_name}/"
cd /home/quant_group/${module_name}/
if [[ "${re_load_config}" = true ]]; then 
	web_no=$((${worker_host:10}))
	basic_no=$((${worker_host:10}))
	mysql_no=$((${worker_host:10}))

	echo "java_start Run ${module_name} start.sh on ${worker_host}, basic_no is ${basic_no}, mysql_no is ${mysql_no}"

	echo "java_start 1. replace application.properties"
	ts=`date +%s`
	echo "curl http://oeazjz3gi.bkt.clouddn.com/qa.${module_name}.application.properties?random=${ts} -o new.application.properties"
	curl http://oeazjz3gi.bkt.clouddn.com/qa.${module_name}.application.properties?random=${ts} -o new.application.properties
	mv -f new.application.properties application.properties

	if [[ "${use_public_ip}" = false ]]; then
		echo "java_start use_public_ip is: ${use_public_ip}!"
		sed -i "s/192.168.4.3/${worker_host}/g" application.properties
	else
		echo "java_start use_public_ip is: ${use_public_ip}!"
		if [ $web_no -lt 100 ]; then
			echo "web_no < 100, ${web_no}"
			sed -i "s/192.168.4.3:7/${public_ip}:${web_no}/g" application.properties
		else
			echo "web_no >= 100, ${web_no}"
			sed -i "s/192.168.4.3:70/${public_ip}:${web_no}/g" application.properties
		fi
	fi

	sed -i "s/192.168.4.4/192.168.4.${basic_no}/g" application.properties
	sed -i "s/192.168.4.5/192.168.4.${mysql_no}/g" application.properties
else
	echo "java_start 1. Skip replace application.properties"
fi

echo "java_start 2. java -jar start"

if [[ "${module_name}" = "xyqb" ]]
then 
	package_name="xyqb-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "pay-center" ]]
then 
	package_name="pay-center-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "han-gu-guan" ]]
then 
	package_name="xyqb-openauth-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "di-ting" ]]
then 
	package_name="xyqb-di_ting-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "jian-men-guan" ]]
then 
	package_name="risk-control-auth-1.0-SNAPSHOT.jar"
elif [[ "${module_name}" = "du-jiang-yan" ]]
then 
	package_name="du-jiang-yan-1.0-SNAPSHOT.jar"
elif [[ "${module_name}" = "financial-system" ]]
then 
	package_name="xyqb-financial_system-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "mall" ]]
then 
	package_name="xyqb-mall-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "quartz" ]]
then 
	package_name="xyqb-quartz-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "red-packet" ]]
then 
	package_name="redpacket-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "xyqb-user" ]]
then 
	package_name=" xyqb-user2-0.0.1-SNAPSHOT.jar"
else
	package_name="${module_name}-0.0.1-SNAPSHOT.jar"
fi

echo "java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps  -jar ${package_name} --worker 1 --currentWorker 1 -t > /dev/null 2>&1 & "
java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps  -jar ${package_name} --worker 1 --currentWorker 1 -t > /dev/null 2>&1 & 

if [ $? -ne 0 ]
then
   echo "Fail to start"
   echo $?
fi
